package tech.atani.client.storage.impl;

import net.minecraft.util.ResourceLocation;
import tech.atani.client.Atani;
import tech.atani.client.storage.Storage;
import tech.atani.client.util.client.interfaces.IMinecraft;
import tech.atani.client.util.client.language.Language;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

public class TranslationStorage extends Storage<String> implements IMinecraft {
    @Override
    public void init() {
        Atani.language = Atani.instance.moduleStorage.getT(tech.atani.client.module.impl.client.Language.class).getLanguage();

        for (Language language : Language.values()) {
            ResourceLocation resourceLocation = new ResourceLocation("atani", language.file);

            try (InputStream stream = mc.getResourceManager().getResource(resourceLocation).getInputStream();
                 BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8))) {

                String line;
                while ((line = reader.readLine()) != null) {
                    line = line.trim();
                    if (line.isEmpty() || line.startsWith("#")) continue;

                    String[] parts = line.split("=", 2);
                    if (parts.length < 2) continue;

                    language.translations.put(parts[0].trim(), parts[1].trim());
                }
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String getTranslation(String key) {
        return getTranslation(key, Atani.language);
    }

    public String getTranslation(String key, Language language) {
        String translated = language.translations.get(key);

        if (translated == null) {
            translated = Atani.language.translations.get(key);
        }

        return translated == null ? key : translated;
    }
}