package tech.atani.client.storage.impl;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import tech.atani.client.storage.Storage;
import tech.atani.client.util.client.interfaces.ILogger;
import tech.atani.client.util.game.render.shader.Shader;
import tech.atani.client.util.game.render.shader.data.ShaderData;

public class ShaderStorage extends Storage<Shader> {

    @Override
    public void init() {
        super.init();
        try (ScanResult scanResult = new ClassGraph().enableClassInfo().enableAnnotationInfo().scan()) {
            scanResult.getClassesWithAnnotation(ShaderData.class.getName()).forEach(classInfo -> {
                try {
                    add((Shader) classInfo.loadClass().getDeclaredConstructor().newInstance());
                } catch (Exception e) {
                    ILogger.logger.error("Failed to load shaders", e);
                }
            });
        }
    }

    @Override
    public void end() {
        super.end();
    }
}