package tech.atani.client.storage.impl;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import tech.atani.client.Atani;
import tech.atani.client.event.impl.KeyEvent;
import tech.atani.client.module.Module;
import tech.atani.client.module.data.Category;
import tech.atani.client.module.data.ModuleData;
import tech.atani.client.module.scripting.ScriptAPI;
import tech.atani.client.storage.Storage;
import tech.atani.client.util.client.events.base.Listen;
import tech.atani.client.util.client.interfaces.ILogger;

import java.util.Set;
import java.util.stream.Collectors;

public class ModuleStorage extends Storage<Module> {
    public Module newestModule;

    public ScriptAPI scriptAPI = new ScriptAPI();

    @Override
    public void init() {
        super.init();
        try (ScanResult scanResult = new ClassGraph().enableClassInfo().enableAnnotationInfo().scan()) {
            scanResult.getClassesWithAnnotation(ModuleData.class.getName()).forEach(classInfo -> {
                try {
                    add((Module) classInfo.loadClass().getDeclaredConstructor().newInstance());
                } catch (Exception e) {
                    ILogger.logger.error("Failed to load modules", e);
                }
            });
        }

        getSet().forEach(Module::onInitialize);

        scriptAPI.loadScripts();
    }

    @Override
    public void end() {
        super.end();
    }

    @Listen
    private void onKey(KeyEvent event) {
        getSet().forEach(m -> {
            if (event.getKey() == m.getKey()) {
                m.toggle();
            }
        });
    }

    public Set<Module> getModulesByCategory(Category input) {
        return getSet().stream()
                .filter(m -> m.getData().category().equals(input))
                .collect(Collectors.toSet());
    }

    public Module last(Category input) {
        return Atani.instance.moduleStorage.getModulesByCategory(input).stream().toList().getLast();
    }

    public Set<Module> getEnabledModules() {
        return getSet().stream()
                .filter(Module::isEnabled)
                .collect(Collectors.toSet());
    }

    public <T extends Module> T getModuleByClass(Class<T> clazz) {
        return getSet().stream()
                .filter(clazz::isInstance)
                .map(clazz::cast)
                .findFirst()
                .orElse(null);
    }

    public Module getModule(String input) {
        return getSet().stream().filter(m -> m.getData().name().equalsIgnoreCase(input)).findFirst().orElse(null);
    }
}