package tech.atani.client.storage.impl;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import net.minecraft.network.play.client.C01PacketChatMessage;
import tech.atani.client.command.Command;
import tech.atani.client.command.data.CommandData;
import tech.atani.client.event.impl.PacketEvent;
import tech.atani.client.storage.Storage;
import tech.atani.client.util.client.events.base.Listen;
import tech.atani.client.util.client.interfaces.ILogger;

import java.util.Arrays;

public class CommandStorage extends Storage<Command> {
    public final String prefix = ".";

    @Override
    public void init() {
        super.init();
        try (ScanResult scanResult = new ClassGraph()
                .enableClassInfo()
                .enableAnnotationInfo()
                .scan()) {
            scanResult.getClassesWithAnnotation(CommandData.class)
                    .forEach(classInfo -> {
                        try {
                            add((Command) classInfo.loadClass()
                                    .getDeclaredConstructor()
                                    .newInstance());
                        } catch (Exception e) {
                            ILogger.logger.error("Failed to load command: {}", classInfo.getName(), e);
                        }
                    });
        }
    }

    @Listen
    public void onPacket(PacketEvent event) {
        if (event.getStage() != PacketEvent.Stage.SENDING ||
                !(event.getPacket() instanceof C01PacketChatMessage packet)) {
            return;
        }

        String msg = packet.getMessage();
        if (!msg.startsWith(prefix)) {
            return;
        }

        String[] splitMsg = msg.split("\\s+");
        getSet().stream()
                .filter(c -> c.isAlias(splitMsg[0].substring(1)))
                .findFirst()
                .ifPresent(cmd -> {
                    event.cancelled = true;
                    cmd.onCommand(Arrays.copyOfRange(splitMsg, 1, splitMsg.length));
                });
    }
}