package tech.atani.client.storage;

import tech.atani.client.util.client.interfaces.IClient;
import tech.atani.client.util.client.interfaces.ISubscriber;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

public class Storage<T> extends CopyOnWriteArrayList<T> implements IClient, ISubscriber, Set<T> {

    @SafeVarargs
    public final void add(final T... t) {
        Collections.addAll(this, t);
    }

    public void init() {
        bus.register(this);
    }

    public void end() {
        bus.unregister(this);
    }

    public Set<T> getSet() {
        return new HashSet<>(this);
    }

    public T first() {
        return isEmpty() ? null : get(0);
    }

    public T last() {
        return isEmpty() ? null : get(size() - 1);
    }

    public <V extends T> V getT(Class<V> clazz) {
        return stream()
                .filter(ob -> ob.getClass().equals(clazz))
                .map(clazz::cast)
                .findFirst()
                .orElse(null);
    }
}