package tech.atani.client.setting.impl;

import lombok.Getter;
import lombok.Setter;
import tech.atani.client.setting.Setting;

@Setter
@Getter
public class StringSetting extends Setting<String> {
    private String[] allValues;
    private boolean expanded;

    public StringSetting(String name, String value, String[] allValues) {
        super(name, value);
        this.allValues = allValues;
    }

    @Override
    public String stringValue() {
        return getValue();
    }

    public void next() {
        if (allValues != null && allValues.length > 0) {
            int currentIndex = index();
            int nextIndex = (currentIndex + 1) % allValues.length;
            setValue(allValues[nextIndex]);
        }
    }

    public void previous() {
        if (allValues != null && allValues.length > 0) {
            int currentIndex = index();
            int previousIndex = (currentIndex - 1 + allValues.length) % allValues.length;
            setValue(allValues[previousIndex]);
        }
    }

    private int index() {
        if (allValues == null || allValues.length == 0) {
            return -1;
        }
        String value = getValue();
        for (int i = 0; i < allValues.length; i++) {
            if (allValues[i].equals(value)) {
                return i;
            }
        }
        return -1;
    }

    public boolean is(String str) {
        return stringValue().equalsIgnoreCase(str);
    }

    public static class Builder {
        private String name;
        private String value;
        private String[] allValues;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public Builder values(String... allValues) {
            this.allValues = allValues;
            return this;
        }

        public StringSetting build() {
            if (name == null || value == null || allValues == null) {
                throw new IllegalArgumentException("Name, value, and allValues must not be null!");
            }
            return new StringSetting(name, value, allValues);
        }
    }
}