package tech.atani.client.setting.impl;

import tech.atani.client.setting.Setting;
import tech.atani.client.util.system.math.MathUtil;

public class SliderSetting extends Setting<Double> {
    public final double min;
    public final double max;
    public final int increment;

    public SliderSetting(String name, double value, double min, double max, int increment) {
        super(name, value);
        this.min = min;
        this.max = max;
        this.increment = increment;
    }

    @Override
    public int intValue() {
        return getValue().intValue();
    }

    @Override
    public double doubleValue() {
        return MathUtil.round(getValue(), increment);
    }

    @Override
    public float floatValue() {
        return MathUtil.round(getValue().floatValue(), increment);
    }

    public static class Builder {
        private String name;
        private double value;
        private double min;
        private double max;
        private int increment;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder value(double value) {
            this.value = value;
            return this;
        }

        public Builder min(double min) {
            this.min = min;
            return this;
        }

        public Builder max(double max) {
            this.max = max;
            return this;
        }

        public Builder increment(int increment) {
            this.increment = increment;
            return this;
        }

        public SliderSetting build() {
            if (name == null) {
                throw new IllegalArgumentException("The setting name must not be null!");
            }
            return new SliderSetting(name, value, min, max, increment);
        }
    }
}