package tech.atani.client.setting.impl;

import lombok.Getter;
import lombok.NonNull;
import lombok.Setter;
import tech.atani.client.setting.Setting;

@Getter
public class RangeSetting extends Setting<Double> {
    private final double min;
    private final double max;
    @Setter
    private double secondValue;
    private final boolean integer;

    public RangeSetting(String name, double value, double secondValue, double min, double max, boolean integer) {
        super(name, value);
        this.secondValue = secondValue;
        this.min = min;
        this.max = max;
        this.integer = integer;
    }

    @Override
    public void setValue(@NonNull Double value) {
        if (value >= min && value <= max) {
            super.setValue(integer ? (double) Math.round(value) : value);
        }
    }

    public double getSecondValue() {
        return integer ? (double) Math.round(secondValue) : secondValue;
    }

    @Override
    public int intValue() {
        return getValue().intValue();
    }

    @Override
    public float floatValue() {
        return getValue().floatValue();
    }

    @Override
    public double doubleValue() {
        return getValue();
    }

    public boolean isValueMin() {
        return getValue() == min;
    }

    public boolean isValueMax() {
        return getValue() == max;
    }

    public static class Builder {
        private String name;
        private double value;
        private double secondValue;
        private double min;
        private double max;
        private boolean integer;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder value(double value) {
            this.value = value;
            return this;
        }

        public Builder secondValue(double secondValue) {
            this.secondValue = secondValue;
            return this;
        }

        public Builder min(double min) {
            this.min = min;
            return this;
        }

        public Builder max(double max) {
            this.max = max;
            return this;
        }

        public Builder integer(boolean integer) {
            this.integer = integer;
            return this;
        }

        public RangeSetting build() {
            if (name == null) {
                throw new IllegalArgumentException("The setting name must not be null!");
            }
            return new RangeSetting(name, value, secondValue, min, max, integer);
        }
    }
}