package tech.atani.client.setting.impl;

import lombok.Getter;
import lombok.NonNull;
import lombok.Setter;
import tech.atani.client.setting.Setting;
import tech.atani.client.util.client.language.TranslationUtil;

@Setter
@Getter
public class MultiSelectSetting extends Setting<String[]> {
    private String[] allValues;
    private boolean expanded;

    public MultiSelectSetting(String name, String[] value, String[] allValues) {
        super(name, value);
        this.allValues = allValues;
    }

    public boolean isEnabled(String value) {
        for (String s : getValue()) {
            if (s.contains(value)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String @NonNull [] getValue() {
        return super.getValue();
    }

    @Override
    public String stringValue() {
        return getValue().length + " " + TranslationUtil.getTranslation("enabled");
    }

    public static class Builder {
        private String name;
        private String[] value;
        private String[] allValues;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder value(String... value) {
            this.value = value;
            return this;
        }

        public Builder values(String... allValues) {
            this.allValues = allValues;
            return this;
        }

        public MultiSelectSetting build() {
            if (name == null || value == null || allValues == null) {
                throw new IllegalArgumentException("Name, value, and allValues must not be null!");
            }
            return new MultiSelectSetting(name, value, allValues);
        }
    }
}