package tech.atani.client.setting.impl;

import lombok.Getter;
import lombok.Setter;
import tech.atani.client.setting.Setting;
import java.awt.Color;

@Setter
@Getter
public class ColorSetting extends Setting<Color> {
    private boolean expanded;

    public ColorSetting(String name, Color value) {
        super(name, value);
    }

    @Override
    public int intValue() {
        return getValue().getRGB();
    }

    @Override
    public String stringValue() {
        Color color = getValue();
        return color.getRed() + ":" + color.getGreen() + ":" + color.getBlue();
    }

    public static class Builder {
        private String name;
        private Color value;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder value(Color value) {
            this.value = value;
            return this;
        }

        public ColorSetting build() {
            if (name == null) {
                throw new IllegalArgumentException("The setting name must not be null!");
            }
            return new ColorSetting(name, value != null ? value : Color.WHITE);
        }
    }
}