package tech.atani.client.setting.impl;

import tech.atani.client.setting.Setting;

public class CheckBoxSetting extends Setting<Boolean> {
    public CheckBoxSetting(String name, boolean value) {
        super(name, value);
    }

    @Override
    public boolean boolValue() {
        return getValue();
    }

    public static class Builder {
        private String name;
        private boolean value;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder value(boolean value) {
            this.value = value;
            return this;
        }

        public CheckBoxSetting build() {
            if (name == null) {
                throw new IllegalArgumentException("The setting name must not be null!");
            }
            return new CheckBoxSetting(name, value);
        }
    }
}