package tech.atani.client.screen.mainMenu;

import tech.atani.client.Atani;
import tech.atani.client.screen.Icon;
import tech.atani.client.util.game.render.animation.Animation;
import tech.atani.client.util.game.render.animation.EnumTransition;
import tech.atani.client.util.game.render.catppuccin.Mocha;
import tech.atani.client.util.game.render.font.gui.font.renderer.SimpleFontRenderer;

import java.awt.*;

public class MainMenuButton {
    private final Animation slideAnim = new Animation(0.f, EnumTransition.SQRT, 5.f);

    private final SimpleFontRenderer logoFont = Atani.instance.fontStorage.getFont("Icons-FilledRounded", 48).newRenderer();
    private final SimpleFontRenderer textFont = Atani.instance.fontStorage.getFont("Inter-Regular", 8).newRenderer();

    private final String logoString;
    private final char logoChar;
    private final String s;
    private final float x;
    private final float y;
    public final Runnable exec;

    public boolean hovered = false;

    public MainMenuButton(Icon logo, String s, float x, float y, Runnable exec) {
        this.logoString = logo.letter;
        this.logoChar = logo.letter.charAt(0);
        this.s = s;
        this.x = x;
        this.y = y;
        this.exec = exec;
    }

    public void draw(int mouseX, int mouseY) {
        float width = this.logoFont.getCharWidth(logoChar);
        float height = this.logoFont.getFontHeight();

        float half = width / 2;

        this.hovered = mouseX >= this.x - half && mouseY >= this.y && mouseX < this.x + half && mouseY < this.y + height;

        slideAnim.update(hovered ? 100 : 0);
        float a = Math.max(0.0f, Math.min(1.0f, slideAnim.getValue() / 100));

        if (a > 0.1) {
            Color textColor = new Color((float) Mocha.TEXT.getRed() / 255, (float) Mocha.TEXT.getGreen() / 255, (float) Mocha.TEXT.getBlue() / 255, a);
            textFont.drawXCenteredString(s, x, y + (height / 2) + (textFont.getFontHeight() * a), textColor.getRGB());
        }

        logoFont.drawXCenteredString(logoString, x, y - (textFont.getFontHeight() * a), Mocha.TEXT);
    }

}
