package tech.atani.client.screen.mainMenu;

import java.io.IOException;
import java.util.*;

import net.minecraft.client.gui.*;
import tech.atani.client.Atani;
import tech.atani.client.screen.altManager.GuiAltManager;
import tech.atani.client.screen.Icon;
import tech.atani.client.util.client.language.TranslationUtil;
import tech.atani.client.util.game.render.catppuccin.Mocha;
import tech.atani.client.util.game.render.font.gui.font.renderer.SimpleFontRenderer;
import tech.atani.client.util.game.render.shader.data.renderer.Renderer;

/**
 * This turned out WAY better than I expected
 *
 * @author Marie
 */
public class GuiMainMenu extends GuiScreen implements GuiYesNoCallback
{
    private final SimpleFontRenderer logoFont = Atani.instance.fontStorage.getFont("Inter-Bold", 36).newRenderer();
    private final SimpleFontRenderer creditsFont = Atani.instance.fontStorage.getFont("Inter-Bold", 12).newRenderer();

    private final ArrayList<MainMenuButton> cButtons = new ArrayList<>();

    public boolean doesGuiPauseGame()
    {
        return false;
    }

    protected void keyTyped(char typedChar, int keyCode) throws IOException
    {
    }

    @Override
    public void initGui() {
        cButtons.clear();

        int buttonHeight = height / 4 + 100;
        float x = (float) width / 2;

        cButtons.add(new MainMenuButton(Icon.PERSON, TranslationUtil.getTranslation("mainmenu.singleplayer"),  x - 200, buttonHeight, () -> mc.displayGuiScreen(new GuiSelectWorld(this))));
        cButtons.add(new MainMenuButton(Icon.MULTIPLE_PEOPLE, TranslationUtil.getTranslation("mainmenu.multiplayer"), x - 100, buttonHeight, () -> mc.displayGuiScreen(new GuiMultiplayer(this))));
        cButtons.add(new MainMenuButton(Icon.MANAGE_PEOPLE, TranslationUtil.getTranslation("mainmenu.altmanager"), x, buttonHeight, () -> mc.displayGuiScreen(new GuiAltManager(this))));
        cButtons.add(new MainMenuButton(Icon.SETTINGS, TranslationUtil.getTranslation("mainmenu.settings"), x + 100, buttonHeight, () -> mc.displayGuiScreen(new GuiOptions(this, mc.gameSettings))));
        cButtons.add(new MainMenuButton(Icon.EXIT, TranslationUtil.getTranslation("mainmenu.exit"), x + 200, buttonHeight, () -> mc.shutdown()));
    }

    @Override
    protected void mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        for (MainMenuButton cButton : cButtons) {
            if (cButton.hovered) cButton.exec.run();
        }
    }

    public void drawScreen(int mouseX, int mouseY, float partialTicks)
    {
        //Renderer.drawRect(0, 0, width, height, 0);
        Renderer.drawNoiseRectangle(0, 0, width, height, Mocha.CRUST, Mocha.BASE, 0.02f);


        logoFont.drawXCenteredGradientString("atani", (float) width /2, (float) height /5, System.currentTimeMillis(), Mocha.CRUST, Mocha.OVERLAY_0);

        creditsFont.drawXYCenteredString(TranslationUtil.getTranslation("mainmenu.credits"), (float) width /2, (float) height-creditsFont.getFontHeight(), Mocha.TEXT);

        for (MainMenuButton cButton : cButtons) {
            cButton.draw(mouseX, mouseY);
        }

        super.drawScreen(mouseX, mouseY, partialTicks);
    }
}
