package tech.atani.client.screen.customPanels.elements.impl;

import tech.atani.client.screen.customPanels.Panel;
import tech.atani.client.screen.customPanels.elements.Element;
import tech.atani.client.screen.vec.SizeVector;
import tech.atani.client.util.game.render.catppuccin.Mocha;
import tech.atani.client.util.game.render.shader.data.renderer.Renderer;

import java.awt.*;

public class LabelRight extends Element {
    public Color textColor = Mocha.OVERLAY_0;
    public LabelRight(Panel parent, SizeVector size, String text, int id) {
        super(parent, size, text, id);
    }

    public LabelRight(Panel parent, String text, int id) {
        super(parent, parent.size, text, id);
    }

    public LabelRight(Panel parent, String text) {
        super(parent, parent.size, text, 0);
    }

    @Override
    public void draw(float y, boolean last) {
        Renderer.drawRoundedSelectiveRectangle(parent.position.x, y, size.width, size.height, size.radius, Mocha.MANTLE.getRGB(), false, false, last, last);
        font.drawYCenteredString(text, parent.position.x - 4 - 2 + size.width - font.getStringWidth(text), y + size.height / 2f, textColor);

        if (isExpanded()) {
            yOffset += 17;
        }
    }
}
