package tech.atani.client.screen.customPanels.elements;

import lombok.Getter;
import lombok.Setter;
import tech.atani.client.Atani;
import tech.atani.client.screen.customPanels.Panel;
import tech.atani.client.screen.vec.SizeVector;
import tech.atani.client.util.game.render.catppuccin.Mocha;
import tech.atani.client.util.game.render.font.gui.font.renderer.SimpleFontRenderer;
import tech.atani.client.util.game.render.shader.data.renderer.Renderer;

public class Element {
    public final SimpleFontRenderer font = Atani.instance.fontStorage.getFont("Google-Regular", 10).newRenderer();

    public final Panel parent;
    public final SizeVector size;
    public final String text;
    public final int id;

    public float yOffset = 0;

    @Getter
    @Setter
    private boolean expanded;

    public Element(Panel parent, SizeVector size, String text, int id) {
        this.parent = parent;
        this.size = size;
        this.text = text;
        this.id = id;
    }

    public void draw(float y, boolean last) {
        Renderer.drawRoundedSelectiveRectangle(parent.position.x, y, size.width, size.height, size.radius, Mocha.MANTLE.getRGB(), false, false, last, last);
        font.drawYCenteredString(text, parent.position.x + 4 + 2, y + size.height / 2f, Mocha.OVERLAY_0);

        if (isExpanded()) {
            yOffset += 17;
        }
    }
}
