package tech.atani.client.screen.customPanels;

import org.lwjgl.util.vector.Vector2f;
import tech.atani.client.Atani;
import tech.atani.client.screen.Icon;
import tech.atani.client.screen.customPanels.elements.Element;
import tech.atani.client.screen.vec.SizeVector;
import tech.atani.client.util.game.render.catppuccin.Mocha;
import tech.atani.client.util.game.render.font.gui.font.renderer.SimpleFontRenderer;
import tech.atani.client.util.game.render.shader.data.renderer.Renderer;

public class Panel {
    private final SimpleFontRenderer font = Atani.instance.fontStorage.getFont("Google-Medium", 11).newRenderer();
    private final SimpleFontRenderer iconFont = Atani.instance.fontStorage.getFont("Icons-FilledRounded", 14).newRenderer();

    public final Vector2f position;
    public final SizeVector size;
    public final String text;
    public final Icon icon;

    public float yOffset = 0;

    public Panel(Vector2f position, SizeVector size, String text, Icon icon) {
        this.position = position;
        this.size = size;
        this.text = text;
        this.icon = icon;
    }

    public Panel(float x, float y, float width, float height, String text, Icon icon) {
        this(new Vector2f(x, y), new SizeVector(width, height), text, icon);
    }

    public void draw(Element... elements) {
        boolean round = elements == null;

        Renderer.drawRoundedSelectiveRectangle(position.x, position.y, size.width, size.height, size.radius, Mocha.BASE.getRGB(), true, true, round, round);

        font.drawYCenteredString(text, position.x - 4 + size.width - font.getStringWidth(text), position.y + size.height / 2f, -1);
        iconFont.drawYCenteredString(icon.letter, position.x + 4, position.y + size.height / 2f, -1);

        if (elements != null) {
            float currentY = position.y + size.height;

            for (int i = 0; i < elements.length; i++) {
                Element element = elements[i];

                element.draw(currentY, i == elements.length - 1);

                currentY += element.size.height;

                if (element.isExpanded()) {
                    currentY += element.yOffset;
                }
            }
        }
    }
}
