package tech.atani.client.screen.clickGui.etc.comp;

import net.minecraft.client.gui.ScaledResolution;
import tech.atani.client.setting.impl.SliderSetting;
import tech.atani.client.util.game.render.animation.Animation;
import tech.atani.client.util.game.render.animation.EnumTransition;
import tech.atani.client.util.game.render.font.gui.font.renderer.SimpleFontRenderer;
import tech.atani.client.util.game.render.shader.data.renderer.Renderer;
import tech.atani.client.util.game.render.catppuccin.Mocha;
import org.lwjgl.opengl.GL11;

import java.awt.Color;

import static tech.atani.client.util.client.interfaces.IMinecraft.mc;

public class SliderComponent extends SettingComponent {
    private final SliderSetting sliderSetting;
    private final Animation slideAnimation = new Animation(0, EnumTransition.EASE_IN_OUT, 23f);
    private final Animation hoverAnimation = new Animation(0, EnumTransition.SQRT, 23f);
    private boolean dragging;

    public SliderComponent(SliderSetting setting, float x, float y, float width) {
        super(setting, x, y, width);
        this.sliderSetting = setting;
    }

    @Override
    public void draw(int mouseX, int mouseY, float partialTicks, float animValue, SimpleFontRenderer bodyFont, SimpleFontRenderer smallFont, Color primaryColor, Color onSurfaceColor, Color secondaryColor) {
        if (animValue <= 0) return;

        double value = sliderSetting.doubleValue();
        double min = sliderSetting.min;
        double max = sliderSetting.max;
        double range = max - min;
        double normalized = (value - min) / range;
        slideAnimation.update((float) normalized);
        hoverAnimation.update(isHovered(x, y, width, 30, mouseX, mouseY) ? 1 : 0);

        if (dragging) {
            updateSlider(mouseX);
        }

        float hoverValue = hoverAnimation.getValue();

        Color trackColor = createHoverColor(Mocha.SURFACE_2, hoverValue, 0.2f);
        Color fillColor = createHoverColor(primaryColor, hoverValue, 0.2f);


        String text = setting.getName() + ": " + String.format("%.1f", value);

        ScaledResolution sr = new ScaledResolution(mc);
        float scaleFactor = sr.getScaleFactor();
        int scissorX = (int) (x * scaleFactor);
        int scissorY = (int) ((mc.displayHeight / scaleFactor - (y + 5 + smallFont.getFontHeight())) * scaleFactor);
        int scissorWidth = (int) (width * scaleFactor);
        int scissorHeight = (int) (smallFont.getFontHeight() * scaleFactor);

        GL11.glEnable(GL11.GL_SCISSOR_TEST);
        GL11.glScissor(scissorX, scissorY, scissorWidth, scissorHeight);
        smallFont.drawString(text, x, y + 5, onSurfaceColor.getRGB());
        GL11.glDisable(GL11.GL_SCISSOR_TEST);

        float sliderY = y + 18;
        Renderer.drawRoundedRect(x, sliderY, width, 2, 1, trackColor);
        float fillWidth = (float) (width * slideAnimation.getValue());
        Renderer.drawRoundedRect(x, sliderY, fillWidth, 2, 1, fillColor);
        Renderer.drawCircle(x + fillWidth, sliderY + 1, 3, fillColor);
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0 && isHovered(x, y + 18, width, 2, mouseX, mouseY)) {
            dragging = true;
            updateSlider(mouseX);
        }
    }

    @Override
    public void mouseReleased(int mouseX, int mouseY, int mouseButton) {
        dragging = false;
    }

    @Override
    public float getHeight() {
        return 22;
    }

    @Override
    public void updateHeight() {}

    @Override
    public void close() {}

    private void updateSlider(int mouseX) {
        double min = sliderSetting.min;
        double max = sliderSetting.max;
        double range = max - min;
        double newValue = min + (range * Math.max(0, Math.min(1, (mouseX - x) / width)));
        sliderSetting.setValue(newValue);
    }

    private boolean isHovered(float x, float y, float width, float height, int mouseX, int mouseY) {
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }
}