package tech.atani.client.screen.clickGui.etc.comp;

import lombok.Getter;
import lombok.Setter;
import tech.atani.client.setting.Setting;
import tech.atani.client.util.game.render.font.gui.font.renderer.SimpleFontRenderer;

import java.awt.Color;

@Getter
@Setter
public abstract class SettingComponent {
    protected final Setting<?> setting;
    protected float x, y, width;

    public SettingComponent(Setting<?> setting, float x, float y, float width) {
        this.setting = setting;
        this.x = x;
        this.y = y;
        this.width = width;
    }

    public abstract void draw(int mouseX, int mouseY, float partialTicks, float animValue, SimpleFontRenderer bodyFont, SimpleFontRenderer smallFont, Color primaryColor, Color onSurfaceColor, Color secondaryColor);

    public abstract void mouseClicked(int mouseX, int mouseY, int mouseButton);

    public abstract void mouseReleased(int mouseX, int mouseY, int mouseButton);

    public abstract float getHeight();

    public abstract void updateHeight();

    public abstract void close();

    Color createHoverColor(Color baseColor, float hoverValue, float intensity) {
        return new Color(
                Math.min(255, Math.max(0, (int) (baseColor.getRed() + (255 - baseColor.getRed()) * hoverValue * intensity))),
                Math.min(255, Math.max(0, (int) (baseColor.getGreen() + (255 - baseColor.getGreen()) * hoverValue * intensity))),
                Math.min(255, Math.max(0, (int) (baseColor.getBlue() + (255 - baseColor.getBlue()) * hoverValue * intensity)))
        );
    }
}