package tech.atani.client.screen.clickGui.etc.comp;

import net.minecraft.client.gui.ScaledResolution;
import tech.atani.client.setting.impl.RangeSetting;
import tech.atani.client.util.game.render.animation.Animation;
import tech.atani.client.util.game.render.animation.EnumTransition;
import tech.atani.client.util.game.render.font.gui.font.renderer.SimpleFontRenderer;
import tech.atani.client.util.game.render.shader.data.renderer.Renderer;
import tech.atani.client.util.game.render.catppuccin.Mocha;
import org.lwjgl.opengl.GL11;

import java.awt.Color;

import static tech.atani.client.util.client.interfaces.IMinecraft.mc;

public class RangeSliderComponent extends SettingComponent {
    private final RangeSetting rangeSetting;
    private final Animation minAnimation = new Animation(0, EnumTransition.EASE_IN_OUT, 23f);
    private final Animation maxAnimation = new Animation(0, EnumTransition.EASE_IN_OUT, 23f);
    private final Animation hoverAnimation = new Animation(0, EnumTransition.SQRT, 23f);
    private boolean dragging_Min = false;
    private boolean dragging_Max = false;

    public RangeSliderComponent(RangeSetting setting, float x, float y, float width) {
        super(setting, x, y, width);
        this.rangeSetting = setting;
    }

    @Override
    public void draw(int mouseX, int mouseY, float partialTicks, float animValue, SimpleFontRenderer bodyFont, SimpleFontRenderer smallFont, Color primaryColor, Color onSurfaceColor, Color secondaryColor) {
        if (animValue <= 0) return;

        double minValue = rangeSetting.doubleValue();
        double maxValue = rangeSetting.getSecondValue();
        double min = rangeSetting.getMin();
        double max = rangeSetting.getMax();
        double range = max - min;

        double normalizedMin = (minValue - min) / range;
        double normalizedMax = (maxValue - min) / range;
        minAnimation.update((float) normalizedMin);
        maxAnimation.update((float) normalizedMax);
        hoverAnimation.update(isHovered(x, y, width, 30, mouseX, mouseY) ? 1 : 0);

        if (dragging_Min) {
            updateMinSlider(mouseX);
        }
        if (dragging_Max) {
            updateMaxSlider(mouseX);
        }

        float hoverValue = hoverAnimation.getValue();

        Color trackColor = createHoverColor(Mocha.SURFACE_2, hoverValue, 0.2f);
        Color fillColor = createHoverColor(primaryColor, hoverValue, 0.2f);

        String text = setting.getName() + ": " + String.format("%.1f - %.1f", minValue, maxValue);

        ScaledResolution sr = new ScaledResolution(mc);
        float scaleFactor = sr.getScaleFactor();
        int scissorX = (int) (x * scaleFactor);
        int scissorY = (int) ((mc.displayHeight / scaleFactor - (y + 6 + smallFont.getFontHeight())) * scaleFactor);
        int scissorWidth = (int) (width * scaleFactor);
        int scissorHeight = (int) (smallFont.getFontHeight() * scaleFactor);

        GL11.glEnable(GL11.GL_SCISSOR_TEST);
        GL11.glScissor(scissorX, scissorY, scissorWidth, scissorHeight);
        smallFont.drawString(text, x, y + 6, onSurfaceColor.getRGB());
        GL11.glDisable(GL11.GL_SCISSOR_TEST);

        float sliderY = y + 18;
        Renderer.drawRoundedRect(x, sliderY, width, 2, 1, trackColor);
        float minPos = width * minAnimation.getValue();
        float maxPos = (float) (width * maxAnimation.getValue());
        Renderer.drawRoundedRect(x + minPos, sliderY, maxPos - minPos, 2, 1, fillColor);
        Renderer.drawCircle(x + minPos, sliderY + 1, 3, fillColor);
        Renderer.drawCircle(x + maxPos, sliderY + 1, 3, fillColor);
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0 && isHovered(x, y + 18, width, 2, mouseX, mouseY)) {
            double minValue = rangeSetting.doubleValue();
            double maxValue = rangeSetting.getSecondValue();
            double min = rangeSetting.getMin();
            double max = rangeSetting.getMax();
            double range = max - min;
            float minPos = (float) (width * (minValue - min) / range);
            float maxPos = (float) (width * (maxValue - min) / range);

            float mousePos = mouseX - x;
            if (Math.abs(mousePos - minPos) < Math.abs(mousePos - maxPos)) {
                dragging_Min = true;
                updateMinSlider(mouseX);
            } else {
                dragging_Max = true;
                updateMaxSlider(mouseX);
            }
        }
    }

    @Override
    public void mouseReleased(int mouseX, int mouseY, int mouseButton) {
        dragging_Min = false;
        dragging_Max = false;
    }

    @Override
    public float getHeight() {
        return 30;
    }

    @Override
    public void updateHeight() {}

    @Override
    public void close() {}

    private void updateMinSlider(int mouseX) {
        double min = rangeSetting.getMin();
        double max = rangeSetting.getMax();
        double range = max - min;
        double newValue = min + (range * Math.max(0, Math.min(1, (mouseX - x) / width)));
        if (newValue <= rangeSetting.getSecondValue()) {
            rangeSetting.setValue(newValue);
        }
    }

    private void updateMaxSlider(int mouseX) {
        double min = rangeSetting.getMin();
        double max = rangeSetting.getMax();
        double range = max - min;
        double newValue = min + (range * Math.max(0, Math.min(1, (mouseX - x) / width)));
        if (newValue >= rangeSetting.doubleValue()) {
            rangeSetting.setSecondValue(newValue);
        }
    }

    private boolean isHovered(float x, float y, float width, float height, int mouseX, int mouseY) {
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }
}