package tech.atani.client.screen.clickGui.etc.comp;

import net.minecraft.client.gui.ScaledResolution;
import tech.atani.client.setting.impl.MultiSelectSetting;
import tech.atani.client.util.game.render.animation.Animation;
import tech.atani.client.util.game.render.animation.EnumTransition;
import tech.atani.client.util.game.render.font.gui.font.renderer.SimpleFontRenderer;
import tech.atani.client.util.game.render.shader.data.renderer.Renderer;
import tech.atani.client.util.game.render.catppuccin.Mocha;
import org.lwjgl.opengl.GL11;

import java.awt.Color;
import java.util.Arrays;

import static tech.atani.client.util.client.interfaces.IMinecraft.mc;

public class MultiStringComponent extends SettingComponent {
    private final MultiSelectSetting multiSelectSetting;
    private final Animation hoverAnimation = new Animation(0, EnumTransition.BOUNCE, 23f);
    private final Animation[] itemHoverAnimations;
    private boolean expanded;
    private float currentHeight;

    public MultiStringComponent(MultiSelectSetting setting, float x, float y, float width) {
        super(setting, x, y, width);
        this.multiSelectSetting = setting;
        this.currentHeight = 30;
        this.itemHoverAnimations = new Animation[multiSelectSetting.getAllValues().length];
        for (int i = 0; i < multiSelectSetting.getAllValues().length; i++) {
            itemHoverAnimations[i] = new Animation(0, EnumTransition.SQRT, 23f);
        }
    }

    @Override
    public void draw(int mouseX, int mouseY, float partialTicks, float animValue, SimpleFontRenderer bodyFont, SimpleFontRenderer smallFont, Color primaryColor, Color onSurfaceColor, Color secondaryColor) {
        if (animValue <= 0) return;

        hoverAnimation.update(isHovered(x, y + 14, width, 12, mouseX, mouseY) ? 1 : 0);
        float hoverValue = hoverAnimation.getValue();

        Color fieldColor = createHoverColor(Mocha.SURFACE_1, hoverValue, 0.2f);

        float fieldY = y + 14;

        ScaledResolution sr = new ScaledResolution(mc);
        float scaleFactor = sr.getScaleFactor();

        int scissorX = (int) (x * scaleFactor);
        int scissorY = (int) ((mc.displayHeight / scaleFactor - (y + 1 + smallFont.getFontHeight())) * scaleFactor);
        int scissorWidth = (int) (width * scaleFactor);
        int scissorHeight = (int) (smallFont.getFontHeight() * scaleFactor);

        GL11.glEnable(GL11.GL_SCISSOR_TEST);
        GL11.glScissor(scissorX, scissorY, scissorWidth, scissorHeight);
        smallFont.drawString(setting.getName(), x, y + 1, onSurfaceColor.getRGB());
        GL11.glDisable(GL11.GL_SCISSOR_TEST);

        float fieldX = x;
        Renderer.drawRoundedRect(fieldX, fieldY, width, 12, 2, fieldColor);

        scissorX = (int) ((fieldX + 3) * scaleFactor);
        scissorY = (int) ((mc.displayHeight / scaleFactor - (fieldY + smallFont.getFontHeight())) * scaleFactor);
        scissorWidth = (int) ((width - 12) * scaleFactor);

        GL11.glEnable(GL11.GL_SCISSOR_TEST);
        GL11.glScissor(scissorX, scissorY, scissorWidth, scissorHeight);
        smallFont.drawString(multiSelectSetting.stringValue(), fieldX + 3, fieldY, Mocha.SUBTEXT_0.getRGB());
        GL11.glDisable(GL11.GL_SCISSOR_TEST);

        Renderer.drawCircle(fieldX + width - 6, fieldY + 6, 2, secondaryColor);

        if (expanded) {
            float dropdownY = y + 28;
            float fullDropdownHeight = multiSelectSetting.getAllValues().length * 12;

            Renderer.drawRoundedRect(x, dropdownY, width, fullDropdownHeight, 3, Mocha.SURFACE_1);

            for (int i = 0; i < multiSelectSetting.getAllValues().length; i++) {
                String value = multiSelectSetting.getAllValues()[i];
                float itemY = dropdownY + (i * 12);

                itemHoverAnimations[i].update(isHovered(x, itemY, width, 12, mouseX, mouseY) ? 1 : 0);
                float itemHoverValue = itemHoverAnimations[i].getValue();

                Color itemBackgroundColor = createHoverColor(Mocha.SURFACE_1, itemHoverValue, 0.1f);

                Renderer.drawRoundedSelectiveRectangle(x, itemY, width, 12, 3, itemBackgroundColor, true, true, true, true);

                Color textColor = multiSelectSetting.isEnabled(value) ? primaryColor : onSurfaceColor;

                scissorX = (int) ((x + 3) * scaleFactor);
                scissorY = (int) ((mc.displayHeight / scaleFactor - (itemY + smallFont.getFontHeight())) * scaleFactor);
                scissorWidth = (int) ((width - 6) * scaleFactor);

                GL11.glEnable(GL11.GL_SCISSOR_TEST);
                GL11.glScissor(scissorX, scissorY, scissorWidth, scissorHeight);
                smallFont.drawString(value, x + 3, itemY, textColor.getRGB());
                GL11.glDisable(GL11.GL_SCISSOR_TEST);
            }
        }
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0) {
            float fieldY = y + 14;
            if (isHovered(x, fieldY, width, 12, mouseX, mouseY)) {
                expanded = !expanded;
                updateHeight();
            } else if (expanded) {
                float dropdownY = y + 28;
                for (int i = 0; i < multiSelectSetting.getAllValues().length; i++) {
                    float itemY = dropdownY + (i * 12);
                    if (isHovered(x, itemY, width, 12, mouseX, mouseY)) {
                        String value = multiSelectSetting.getAllValues()[i];
                        toggleValue(value);
                        updateHeight();
                        break;
                    }
                }
            }
        }
    }

    @Override
    public void mouseReleased(int mouseX, int mouseY, int mouseButton) {}

    @Override
    public float getHeight() {
        return currentHeight;
    }

    @Override
    public void updateHeight() {
        currentHeight = 25 + (expanded ? multiSelectSetting.getAllValues().length * 12 : 0);
    }

    @Override
    public void close() {
        expanded = false;
        updateHeight();
    }

    private void toggleValue(String value) {
        String[] currentValues = multiSelectSetting.getValue();
        if (multiSelectSetting.isEnabled(value)) {
            String[] newValues = new String[currentValues.length - 1];
            int index = 0;
            for (String s : currentValues) {
                if (!s.equals(value)) {
                    newValues[index++] = s;
                }
            }
            multiSelectSetting.setValue(newValues);
        } else {
            String[] newValues = Arrays.copyOf(currentValues, currentValues.length + 1);
            newValues[currentValues.length] = value;
            multiSelectSetting.setValue(newValues);
        }
    }

    private boolean isHovered(float x, float y, float width, float height, int mouseX, int mouseY) {
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }
}