package tech.atani.client.screen.clickGui.etc.comp;

import net.minecraft.client.gui.ScaledResolution;
import tech.atani.client.setting.impl.ColorSetting;
import tech.atani.client.util.game.render.animation.Animation;
import tech.atani.client.util.game.render.animation.EnumTransition;
import tech.atani.client.util.game.render.font.gui.font.renderer.SimpleFontRenderer;
import tech.atani.client.util.game.render.shader.data.renderer.Renderer;
import tech.atani.client.util.game.render.catppuccin.Mocha;
import org.lwjgl.opengl.GL11;

import java.awt.Color;

import static tech.atani.client.util.client.interfaces.IMinecraft.mc;

public class ColorComponent extends SettingComponent {
    private final ColorSetting colorSetting;
    private final Animation hoverAnimation = new Animation(0, EnumTransition.SQRT, 23f);
    private boolean expanded;
    private float currentHeight;
    private boolean draggingSB = false;
    private boolean draggingHue = false;
    private boolean draggingAlpha = false;
    private float hue = 0;
    private float saturation = 1;
    private float brightness = 1;
    private float alpha = 1;

    public ColorComponent(ColorSetting setting, float x, float y, float width) {
        super(setting, x, y, width);
        this.colorSetting = setting;
        this.currentHeight = 20;
        updateHSBFromColor();
    }

    @Override
    public void draw(int mouseX, int mouseY, float partialTicks, float animValue, SimpleFontRenderer bodyFont, SimpleFontRenderer smallFont, Color primaryColor, Color onSurfaceColor, Color secondaryColor) {
        if (animValue <= 0) return;

        hoverAnimation.update(isHovered(x, y, width, 20, mouseX, mouseY) ? 1 : 0);
        float hoverValue = hoverAnimation.getValue();

        if (draggingSB) {
            updateSB(mouseX, mouseY);
        }
        if (draggingHue) {
            updateHue(mouseX);
        }
        if (draggingAlpha) {
            updateAlpha(mouseX);
        }

        Color hoverColor = createHoverColor(onSurfaceColor, hoverValue, 0.2f);

        float maxTextWidth = width - 16;

        ScaledResolution sr = new ScaledResolution(mc);
        float scaleFactor = sr.getScaleFactor();
        int scissorX = (int) (x * scaleFactor);
        int scissorY = (int) ((mc.displayHeight / scaleFactor - (y + 6 + smallFont.getFontHeight())) * scaleFactor);
        int scissorWidth = (int) (maxTextWidth * scaleFactor);
        int scissorHeight = (int) (smallFont.getFontHeight() * scaleFactor);

        GL11.glEnable(GL11.GL_SCISSOR_TEST);
        GL11.glScissor(scissorX, scissorY, scissorWidth, scissorHeight);
        smallFont.drawString(setting.getName(), x, y + 6, hoverColor.getRGB());
        GL11.glDisable(GL11.GL_SCISSOR_TEST);

        float colorBoxX = x + width - 12;
        float colorBoxY = y + 5;
        Renderer.drawRoundedRect(colorBoxX, colorBoxY, 10, 10, 1, colorSetting.getValue());

        if (expanded) {
            float pickerY = y + 20;
            float sbWidth = width - 4;
            float sbHeight = 60;
            float hueHeight = 10;
            float alphaHeight = 10;

            float sbX = x + 2;
            Renderer.drawRoundedRect(sbX, pickerY, sbWidth, sbHeight, 2, Mocha.SURFACE_1);
            drawSBGradient(sbX, pickerY, sbWidth, sbHeight, hue);
            float sbPosX = sbX + (saturation * sbWidth);
            float sbPosY = pickerY + ((1 - brightness) * sbHeight);
            Renderer.drawCircle(sbPosX, sbPosY, 2, Color.WHITE);

            float hueY = pickerY + sbHeight + 8;
            Renderer.drawRoundedRect(x + 2, hueY, sbWidth, hueHeight, 2, Mocha.SURFACE_1);
            drawHueGradient(x + 2, hueY, sbWidth, hueHeight);
            float hueX = x + 2 + (hue * sbWidth);
            Renderer.drawCircle(hueX, hueY + (hueHeight / 2), 2, Color.WHITE);

            float alphaY = hueY + hueHeight + 4;
            Renderer.drawRoundedRect(x + 2, alphaY, sbWidth, alphaHeight, 2, Mocha.SURFACE_1);
            drawAlphaGradient(x + 2, alphaY, sbWidth, alphaHeight, Color.getHSBColor(hue, saturation, brightness));
            float alphaX = x + 2 + (alpha * sbWidth);
            Renderer.drawCircle(alphaX, alphaY + (alphaHeight / 2), 2, Color.WHITE);
        }
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0) {
            if (isHovered(x, y, width, 20, mouseX, mouseY)) {
                expanded = !expanded;
                updateHeight();
            } else if (expanded) {
                float pickerY = y + 20;
                float sbHeight = 60;
                float hueHeight = 10;
                float alphaHeight = 10;

                if (isHovered(x + 2, pickerY, width - 4, sbHeight, mouseX, mouseY)) {
                    draggingSB = true;
                    updateSB(mouseX, mouseY);
                }

                float hueY = pickerY + sbHeight + 8;
                if (isHovered(x + 2, hueY, width - 4, hueHeight, mouseX, mouseY)) {
                    draggingHue = true;
                    updateHue(mouseX);
                }

                float alphaY = hueY + hueHeight + 8;
                if (isHovered(x + 2, alphaY, width - 4, alphaHeight, mouseX, mouseY)) {
                    draggingAlpha = true;
                    updateAlpha(mouseX);
                }
            }
        }
    }

    @Override
    public void mouseReleased(int mouseX, int mouseY, int mouseButton) {
        draggingSB = false;
        draggingHue = false;
        draggingAlpha = false;
    }

    @Override
    public float getHeight() {
        return currentHeight;
    }

    @Override
    public void updateHeight() {
        currentHeight = 20 + (expanded ? 90 : 0);
    }

    @Override
    public void close() {
        expanded = false;
        updateHeight();
    }

    private void updateSB(int mouseX, int mouseY) {
        float pickerY = y + 20;
        float sbWidth = width - 4;
        float sbHeight = 60;
        saturation = Math.max(0, Math.min(1, (mouseX - (x + 2)) / sbWidth));
        brightness = 1 - Math.max(0, Math.min(1, (mouseY - pickerY) / sbHeight));
        updateColor();
    }

    private void updateHue(int mouseX) {
        hue = Math.max(0, Math.min(1, (mouseX - (x + 2)) / (width - 4)));
        updateColor();
    }

    private void updateAlpha(int mouseX) {
        alpha = Math.max(0, Math.min(1, (mouseX - (x + 2)) / (width - 4)));
        updateColor();
    }

    private void updateColor() {
        Color newColor = Color.getHSBColor(hue, saturation, brightness);
        colorSetting.setValue(new Color(newColor.getRed(), newColor.getGreen(), newColor.getBlue(), (int) (alpha * 255)));
    }

    private void updateHSBFromColor() {
        Color color = colorSetting.getValue();
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        hue = hsb[0];
        saturation = hsb[1];
        brightness = hsb[2];
        alpha = color.getAlpha() / 255f;
    }

    private void drawSBGradient(float x, float y, float width, float height, float hue) {
        for (int i = 0; i < width; i++) {
            for (int j = 0; j < height; j++) {
                float s = i / width;
                float b = 1 - (j / height);
                Renderer.drawRectangle(x + i, y + j, 1, 1, Color.getHSBColor(hue, s, b));
            }
        }
    }

    private void drawHueGradient(float x, float y, float width, float height) {
        for (int i = 0; i < width; i++) {
            float h = i / width;
            Renderer.drawRectangle(x + i, y, 1, height, Color.getHSBColor(h, 1, 1));
        }
    }

    private void drawAlphaGradient(float x, float y, float width, float height, Color baseColor) {
        for (int i = 0; i < width; i++) {
            float a = i / width;
            Renderer.drawRectangle(x + i, y, 1, height, new Color(baseColor.getRed(), baseColor.getGreen(), baseColor.getBlue(), (int) (a * 255)));
        }
    }

    private boolean isHovered(float x, float y, float width, float height, int mouseX, int mouseY) {
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }
}