package tech.atani.client.screen.clickGui.etc.comp;

import net.minecraft.client.gui.ScaledResolution;
import tech.atani.client.setting.impl.CheckBoxSetting;
import tech.atani.client.util.game.render.animation.Animation;
import tech.atani.client.util.game.render.animation.EnumTransition;
import tech.atani.client.util.game.render.font.gui.font.renderer.SimpleFontRenderer;
import tech.atani.client.util.game.render.shader.data.renderer.Renderer;
import org.lwjgl.opengl.GL11;

import java.awt.Color;

import static tech.atani.client.util.client.interfaces.IMinecraft.mc;

public class CheckBoxComponent extends SettingComponent {
    private final CheckBoxSetting checkBoxSetting;
    private final Animation checkAnimation = new Animation(0, EnumTransition.BOUNCE, 20f);
    private final Animation hoverAnimation = new Animation(0, EnumTransition.SQRT, 23f);

    public CheckBoxComponent(CheckBoxSetting setting, float x, float y, float width) {
        super(setting, x, y, width);
        this.checkBoxSetting = setting;
    }

    @Override
    public void draw(int mouseX, int mouseY, float partialTicks, float animValue, SimpleFontRenderer bodyFont, SimpleFontRenderer smallFont, Color primaryColor, Color onSurfaceColor, Color secondaryColor) {
        if (animValue <= 0) return;

        checkAnimation.update(checkBoxSetting.getValue() ? 1 : 0);
        hoverAnimation.update(isHovered(x, y, width, getHeight(), mouseX, mouseY) ? 1 : 0);
        float anim = checkAnimation.getValue();
        float hoverValue = hoverAnimation.getValue();

        Color trackColor = checkBoxSetting.getValue() ? primaryColor : onSurfaceColor;

        Color hoverColor = createHoverColor(trackColor, hoverValue, 0.2f);

        float textWidth = smallFont.getStringWidth(setting.getName());
        float maxTextWidth = width - 24;

        ScaledResolution sr = new ScaledResolution(mc);
        float scaleFactor = sr.getScaleFactor();
        int scissorX = (int) (x * scaleFactor);
        int scissorY = (int) ((mc.displayHeight / scaleFactor - (y + smallFont.getFontHeight())) * scaleFactor);
        int scissorWidth = (int) (maxTextWidth * scaleFactor);
        int scissorHeight = (int) (smallFont.getFontHeight() * scaleFactor);

        GL11.glEnable(GL11.GL_SCISSOR_TEST);
        GL11.glScissor(scissorX, scissorY, scissorWidth, scissorHeight);
        smallFont.drawString(setting.getName(), x, y, onSurfaceColor.getRGB());
        GL11.glDisable(GL11.GL_SCISSOR_TEST);

        float textCenterY = y + (float) smallFont.getFontHeight() / 2;
        float switchHeight = 10;
        float switchX = x + width - 20;
        float switchY = textCenterY - switchHeight / 2;

        Renderer.drawRoundedRect(switchX, switchY, 20, switchHeight, 4, hoverColor);
        float thumbX = switchX + (anim * 10);
        Renderer.drawCircle(thumbX + 5, switchY + switchHeight / 2, 3, Color.WHITE);
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0 && isHovered(x, y, width, getHeight(), mouseX, mouseY)) {
            checkBoxSetting.setValue(!checkBoxSetting.getValue());
        }
    }

    @Override
    public void mouseReleased(int mouseX, int mouseY, int mouseButton) {}

    @Override
    public float getHeight() {
        return 12;
    }

    @Override
    public void updateHeight() {}

    @Override
    public void close() {}

    private boolean isHovered(float x, float y, float width, float height, int mouseX, int mouseY) {
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }
}