package tech.atani.client.screen.clickGui.etc;

import lombok.Setter;
import net.minecraft.client.gui.ScaledResolution;
import tech.atani.client.module.Module;
import tech.atani.client.screen.clickGui.etc.comp.*;
import tech.atani.client.setting.Setting;
import tech.atani.client.setting.impl.*;
import tech.atani.client.util.game.render.font.gui.font.renderer.SimpleFontRenderer;
import org.lwjgl.opengl.GL11;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

import static tech.atani.client.util.client.interfaces.IMinecraft.mc;

public class ModulePanel {
    private final Module module;
    @Setter
    private float x, y;
    private final float width;
    private final float height = 20;
    private final List<SettingComponent> components = new ArrayList<>();
    private boolean expanded = false;
    private float currentHeight;

    public ModulePanel(Module module, float x, float y, float width) {
        this.module = module;
        this.x = x;
        this.y = y;
        this.width = width;
        float settingY = y + height + 1;
        for (Setting<?> setting : module.getSettings()) {
            switch (setting) {
                case CheckBoxSetting checkBoxSetting -> {
                    components.add(new CheckBoxComponent(checkBoxSetting, x + 2, settingY, width - 4));
                    settingY += 12;
                }
                case SliderSetting sliderSetting -> {
                    components.add(new SliderComponent(sliderSetting, x + 2, settingY, width - 4));
                    settingY += 30;
                }
                case StringSetting stringSetting -> {
                    components.add(new StringComponent(stringSetting, x + 2, settingY, width - 4));
                    settingY += 30;
                }
                case ColorSetting colorSetting -> {
                    components.add(new ColorComponent(colorSetting, x + 2, settingY, width - 4));
                    settingY += 20;
                }
                case RangeSetting rangeSetting -> {
                    components.add(new RangeSliderComponent(rangeSetting, x + 2, settingY, width - 4));
                    settingY += 30;
                }
                case MultiSelectSetting multiSelectSetting -> {
                    components.add(new MultiStringComponent(multiSelectSetting, x + 2, settingY, width - 4));
                    settingY += 30;
                }
                default -> {
                }
            }
        }
        currentHeight = height;
    }

    public void draw(int mouseX, int mouseY, float partialTicks, SimpleFontRenderer bodyFont, SimpleFontRenderer smallFont, Color primaryColor, Color surfaceColor, Color onSurfaceColor, Color secondaryColor) {
        Color moduleColor = module.isEnabled() ? primaryColor : onSurfaceColor;
        float textX = x + (width - bodyFont.getStringWidth(module.getName())) / 2;

        ScaledResolution sr = new ScaledResolution(mc);
        float scaleFactor = sr.getScaleFactor();
        int scissorX = (int) (x * scaleFactor);
        int scissorY = (int) ((mc.displayHeight / scaleFactor - (y + 6 + bodyFont.getFontHeight())) * scaleFactor);
        int scissorWidth = (int) (width * scaleFactor);
        int scissorHeight = (int) (bodyFont.getFontHeight() * scaleFactor);

        GL11.glEnable(GL11.GL_SCISSOR_TEST);
        GL11.glScissor(scissorX, scissorY, scissorWidth, scissorHeight);
        bodyFont.drawString(module.getName(), textX, y + 6, moduleColor);
        GL11.glDisable(GL11.GL_SCISSOR_TEST);

        if (expanded) {
            float settingY = y + height + 1;
            for (SettingComponent component : components) {
                if (component.getSetting().getHidden().getAsBoolean()) {
                    continue;
                }

                component.setY(settingY);
                component.draw(mouseX, mouseY, partialTicks, 1, bodyFont, smallFont, primaryColor, onSurfaceColor, secondaryColor);
                settingY += component.getHeight() + 1;
            }
        }
    }

    public void updateHeight() {
        float totalHeight = height;
        if (expanded) {
            for (SettingComponent component : components) {
                if (component.getSetting().getHidden().getAsBoolean()) {
                    continue;
                }

                component.updateHeight();
                totalHeight += component.getHeight() + 1;
            }
        }
        currentHeight = totalHeight;
    }

    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (isHovered(x, y, width, height, mouseX, mouseY)) {
            if (mouseButton == 0) {
                module.toggle();
            } else if (mouseButton == 1 && !module.getSettings().isEmpty()) {
                expanded = !expanded;
            }
        }
        if (expanded) {
            for (SettingComponent component : components) {
                if (component.getSetting().getHidden().getAsBoolean()) {
                    continue;
                }

                component.mouseClicked(mouseX, mouseY, mouseButton);
            }
        }
    }

    public void mouseReleased(int mouseX, int mouseY, int mouseButton) {
        if (expanded) {
            for (SettingComponent component : components) {
                if (component.getSetting().getHidden().getAsBoolean()) {
                    continue;
                }

                component.mouseReleased(mouseX, mouseY, mouseButton);
            }
        }
    }

    public void closeSettings() {
        expanded = false;
        for (SettingComponent component : components) {
            if (component.getSetting().getHidden().getAsBoolean()) {
                continue;
            }

            component.close();
        }
    }

    public float getHeight() {
        return currentHeight;
    }

    private boolean isHovered(float x, float y, float width, float height, int mouseX, int mouseY) {
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }
}