package tech.atani.client.screen.clickGui.etc;

import lombok.Getter;
import lombok.Setter;
import net.minecraft.client.gui.ScaledResolution;
import tech.atani.client.Atani;
import tech.atani.client.module.Module;
import tech.atani.client.module.data.Category;
import tech.atani.client.util.game.render.font.gui.font.renderer.SimpleFontRenderer;
import tech.atani.client.util.game.render.shader.data.renderer.Renderer;
import tech.atani.client.util.game.render.catppuccin.Mocha;
import org.lwjgl.opengl.GL11;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import static tech.atani.client.util.client.interfaces.IMinecraft.mc;

@Getter
@Setter
public class CategoryPanel {
    private final Category category;
    private final float x;
    private float y;
    private final float width = 120;
    private final float headerHeight = 22;
    private final List<ModulePanel> modulePanels = new ArrayList<>();
    private boolean expanded = false;
    private float currentHeight;

    public CategoryPanel(Category category, float x, float y) {
        this.category = category;
        this.x = x;
        this.y = y;
        float moduleY = y + headerHeight;
        Set<Module> modules = Atani.instance.moduleStorage.getModulesByCategory(category);
        for (Module module : modules) {
            modulePanels.add(new ModulePanel(module, x, moduleY, width));
            moduleY += 20;
        }
        currentHeight = headerHeight;
    }

    public void draw(int mouseX, int mouseY, float partialTicks, SimpleFontRenderer titleFont, SimpleFontRenderer bodyFont, SimpleFontRenderer smallFont, Color primaryColor, Color surfaceColor, Color onSurfaceColor, Color secondaryColor) {
        float totalHeight = headerHeight;
        if (expanded) {
            float moduleY = y + headerHeight;
            for (ModulePanel modulePanel : modulePanels) {
                modulePanel.setY(moduleY);
                modulePanel.updateHeight();
                totalHeight += modulePanel.getHeight() + 1;
                moduleY += modulePanel.getHeight() + 1;
            }
        }
        currentHeight = totalHeight;

        Renderer.drawRoundedSelectiveRectangle(x, y, width, headerHeight, 4, Mocha.BASE, true, true, false, false);
        if (totalHeight > headerHeight) {
            Renderer.drawRoundedSelectiveRectangle(x, y + headerHeight, width, totalHeight - headerHeight + 4, 4, surfaceColor, false, false, true, true);
        }
        float textX = x + (width - titleFont.getStringWidth(category.getName())) / 2;

        ScaledResolution sr = new ScaledResolution(mc);
        float scaleFactor = sr.getScaleFactor();
        int scissorX = (int) (x * scaleFactor);
        int scissorY = (int) ((mc.displayHeight / scaleFactor - (y + 2.5f + titleFont.getFontHeight())) * scaleFactor);
        int scissorWidth = (int) (width * scaleFactor);
        int scissorHeight = (int) (titleFont.getFontHeight() * scaleFactor);

        GL11.glEnable(GL11.GL_SCISSOR_TEST);
        GL11.glScissor(scissorX, scissorY, scissorWidth, scissorHeight);
        titleFont.drawString(category.getName(), textX, y + 2.5f, onSurfaceColor.getRGB());
        GL11.glDisable(GL11.GL_SCISSOR_TEST);

        if (expanded) {
            float moduleY = y + headerHeight;
            for (ModulePanel modulePanel : modulePanels) {
                modulePanel.setY(moduleY);
                modulePanel.draw(mouseX, mouseY, partialTicks, bodyFont, smallFont, primaryColor, surfaceColor, onSurfaceColor, secondaryColor);
                moduleY += modulePanel.getHeight() + 1;
            }
        }
    }

    public void updateHeight() {
        float totalHeight = headerHeight;
        if (expanded) {
            for (ModulePanel modulePanel : modulePanels) {
                modulePanel.updateHeight();
                totalHeight += modulePanel.getHeight() + 1;
            }
        }
        currentHeight = totalHeight;
    }

    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (isHovered(x, y, width, headerHeight, mouseX, mouseY)) {
            if (mouseButton == 0) {
                expanded = !expanded;
                if (!expanded) {
                    for (ModulePanel modulePanel : modulePanels) {
                        modulePanel.closeSettings();
                    }
                }
            }
        }
        if (expanded) {
            for (ModulePanel modulePanel : modulePanels) {
                modulePanel.mouseClicked(mouseX, mouseY, mouseButton);
            }
        }
    }

    public void mouseReleased(int mouseX, int mouseY, int mouseButton) {
        if (expanded) {
            for (ModulePanel modulePanel : modulePanels) {
                modulePanel.mouseReleased(mouseX, mouseY, mouseButton);
            }
        }
    }

    private boolean isHovered(float x, float y, float width, float height, int mouseX, int mouseY) {
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }

    public float getHeight() {
        return currentHeight;
    }
}