package tech.atani.client.screen.clickGui;

import com.google.gson.JsonObject;
import net.minecraft.client.gui.GuiScreen;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.util.vector.Vector2f;
import tech.atani.client.Atani;
import tech.atani.client.file.impl.KeybindFile;
import tech.atani.client.file.impl.ModuleFile;
import tech.atani.client.module.Module;
import tech.atani.client.module.data.Category;
import tech.atani.client.module.impl.client.Theme;
import tech.atani.client.setting.Setting;
import tech.atani.client.setting.impl.*;
import tech.atani.client.screen.IconUtil;
import tech.atani.client.screen.vec.IconVector;
import tech.atani.client.screen.vec.SizeVector;
import tech.atani.client.util.client.language.TranslationUtil;
import tech.atani.client.util.game.render.Utility;
import tech.atani.client.util.game.render.animation.Animation;
import tech.atani.client.util.game.render.animation.EnumTransition;
import tech.atani.client.util.game.render.catppuccin.Mocha;
import tech.atani.client.util.game.render.font.gui.font.renderer.SimpleFontRenderer;
import tech.atani.client.util.game.render.shader.data.renderer.Renderer;
import tech.atani.client.util.system.math.MathUtil;
import tech.atani.client.util.system.thread.ThreadUtil;

import java.awt.*;
import java.io.IOException;
import java.util.*;
import java.util.List;

public class ModernClickGUI extends GuiScreen {

    private final Map<Category, Vector2f> positions = new HashMap<>();
    private final Map<Category, Animation> animations = new HashMap<>();
    private final Map<Category, Float> baseYPositions = new HashMap<>();
    private final SizeVector size = new SizeVector(120, 22, 5);

    private final SimpleFontRenderer categoryFont = Atani.instance.fontStorage.getFont("Google-Medium", 11).newRenderer();
    private final SimpleFontRenderer iconFont = Atani.instance.fontStorage.getFont("Icons-FilledRounded", 14).newRenderer();
    private final SimpleFontRenderer moduleFont = Atani.instance.fontStorage.getFont("Google-Regular", 10).newRenderer();
    private final SimpleFontRenderer settingFont = Atani.instance.fontStorage.getFont("Google-Regular", 9).newRenderer();

    private boolean closing = false;
    private Setting<?> focusedSetting = null;

    public ModernClickGUI() {
        float xOffset = 10;

        if (Atani.instance.fileStorage.config.has("Modern CGUI")) {
            JsonObject cguiObj = Atani.instance.fileStorage.config.getAsJsonObject("Modern CGUI");

            for (Category category : Category.values()) {
                JsonObject catObj = cguiObj.has(category.getName()) ? cguiObj.getAsJsonObject(category.getName()) : null;
                if (catObj != null) {
                    float y = catObj.get("Y").getAsFloat();
                    positions.put(category, new Vector2f(catObj.get("X").getAsFloat(), y));
                    baseYPositions.put(category, y);
                }
            }
        } else {
            for (Category category : Category.values()) {
                positions.put(category, new Vector2f(xOffset, 10));
                baseYPositions.put(category, 10f);
                xOffset += size.width + size.padding;
            }
        }
    }

    @Override
    public void initGui() {
        closing = false;
        animations.clear();

        for (Category category : Category.values()) {
            animations.put(category, new Animation(-size.height, EnumTransition.SQRT, 5f));
        }

        focusedSetting = null;
        Keyboard.enableRepeatEvents(true);
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        boolean allAnimationsDone = true;

        Color mainColor = Theme.getMainColor();

        for (Category category : positions.keySet()) {
            Vector2f pos = positions.get(category);
            Animation anim = animations.get(category);

            float targetY = closing ? -size.height - 80 : baseYPositions.get(category);
            anim.update(targetY);
            pos.y = anim.getValue();

            if (Math.abs(pos.y - targetY) > 0.1f) {
                allAnimationsDone = false;
            }

            pos = drag(mouseX, mouseY, category, pos);

            boolean empty = Atani.instance.moduleStorage.getModulesByCategory(category).isEmpty();
            Renderer.drawRoundedSelectiveRectangle(pos.x - 5, pos.y - 5, size.width, size.height, 4, Mocha.BASE.getRGB(), true, true, empty, empty);

            IconVector iconVector = IconUtil.getCategoryIcon(category);
            iconFont.drawYCenteredString(iconVector.icon.letter, pos.x + iconVector.x, pos.y + 13 / 2f, -1);
            categoryFont.drawYCenteredString(category.getName(), pos.x + 110 - categoryFont.getStringWidth(category.getName()), pos.y + 13 / 2f, -1);

            float yOffset = pos.y + size.height - 1;
            for (Module module : Atani.instance.moduleStorage.getModulesByCategory(category)) {
                boolean last = Atani.instance.moduleStorage.last(category) == module;
                if (module.isExpanded())
                    last = false;
                boolean hover = Utility.isHover(mouseX, mouseY, pos.x - 5, yOffset - 5, size.width, size.height);

                Renderer.drawRoundedSelectiveRectangle(pos.x - 5, yOffset - 5, size.width, size.height, 4, Mocha.MANTLE.getRGB(), false, false, last, last);

                moduleFont.drawYCenteredString(module.getName(), pos.x + 2, yOffset + 7, module.isEnabled() ? hover ? Mocha.TEXT.brighter() : Mocha.TEXT : hover ? Mocha.SUBTEXT_0 : Mocha.OVERLAY_0);

                if (module.isExpanded()) {
                    for (Setting<?> setting : module.getSettings()) {
                        if (setting.getHidden().getAsBoolean()) {
                            continue;
                        }

                        switch (setting) {
                            case CheckBoxSetting cb -> {
                                float yThing = 17;
                                yOffset += yThing - 1;
                                boolean hoverCB = Utility.isHover(mouseX, mouseY, pos.x - 5, yOffset, size.width, yThing);
                                Renderer.drawRoundedSelectiveRectangle(pos.x - 5, yOffset, size.width, yThing, 4, Mocha.MANTLE_1.getRGB(), false, false, false, false);

                                float switchTrackWidth = 20;
                                float switchTrackHeight = 11;
                                float switchThumbSize = 9f;
                                float rightPadding = 5f;
                                float switchX = pos.x + size.width - rightPadding - switchTrackWidth - 7.5f;
                                float switchY = yOffset + (yThing - switchTrackHeight) / 2f;

                                float thumbOffset = cb.getValue() ? switchTrackWidth - switchThumbSize - 1 : 1;

                                Renderer.drawRoundedRect(switchX, switchY, switchTrackWidth, switchTrackHeight, 5, cb.getValue() ? mainColor : Mocha.OVERLAY_0);
                                Renderer.drawCircle(switchX + thumbOffset + switchThumbSize / 2f, switchY + switchTrackHeight / 2f, 4, cb.getValue() ? mainColor.darker() : Mocha.TEXT);

                                settingFont.drawYCenteredString(cb.getName(), pos.x + 2, yOffset + yThing / 2f, cb.getValue() ? (hoverCB ? Mocha.TEXT.brighter() : Mocha.TEXT) : (hoverCB ? Mocha.SUBTEXT_0 : Mocha.OVERLAY_0));
                            }
                            case StringSetting s -> {
                                float yThing = 17;
                                yOffset += yThing - 1;

                                boolean hoverCB = Utility.isHover(mouseX, mouseY, pos.x - 5, yOffset, size.width, yThing);

                                Renderer.drawRoundedSelectiveRectangle(pos.x - 5, yOffset, size.width, yThing, 0, Mocha.MANTLE_1.getRGB(), false, false, false, false);

                                float boxWidth = settingFont.getStringWidth(s.getValue()) + 4;
                                float boxHeight = 12;
                                float boxRadius = 3;
                                float boxPadding = 7f;
                                float boxX = pos.x + size.width - boxWidth - boxPadding - 5.5f;

                                float yOffset2 = 2.5f;
                                float boxY = yOffset + yOffset2;

                                Renderer.drawRoundedRect(boxX, boxY, boxWidth, boxHeight, boxRadius, Mocha.MANTLE.brighter());
                                settingFont.drawYCenteredString(s.getName(), pos.x + 2, yOffset + yThing / 2f, hoverCB ? Mocha.TEXT.brighter() : Mocha.TEXT);
                                settingFont.drawXYCenteredString(s.getValue(), boxX + boxWidth / 2, yOffset + boxHeight / 2 + yOffset2, Mocha.TEXT);
                            }
                            case ColorSetting c -> {
                                float boxHeight = 17;
                                yOffset += 17 - 1;

                                boolean hoverCB = Utility.isHover(mouseX, mouseY, pos.x - 5, yOffset, size.width, 17);

                                if (c.isExpanded()) {
                                    boxHeight += 22 * 4 + 2;
                                }

                                Renderer.drawRoundedSelectiveRectangle(pos.x - 5, yOffset, size.width, boxHeight, 0, Mocha.MANTLE_1.getRGB(), false, false, false, false);

                                float boxWidth = settingFont.getStringWidth("22") + 4;
                                float boxX = pos.x + size.width - boxWidth - 7 - 5.5f;

                                float boxY = yOffset + 2.5f;

                                Renderer.drawRoundedRect(boxX, boxY, boxWidth, 12, 3, Mocha.MANTLE.brighter());
                                Renderer.drawRoundedRect(boxX + 2, boxY + 2, boxWidth - 4, 12 - 4, 2, c.getValue());
                                settingFont.drawYCenteredString(c.getName(), pos.x + 2, yOffset + 17 / 2f, hoverCB ? Mocha.TEXT.brighter() : Mocha.TEXT);

                                if (c.isExpanded()) {
                                    yOffset += 22;

                                    float min = 0;
                                    float max = 255;
                                    float maxWidth = 105;
                                    float sliderHeight = 6;
                                    float sliderRadius = 3;

                                    Renderer.drawRoundedRect(pos.x - 2, yOffset - 6, size.width - 6, 22 * 4 + 3, 3, Mocha.SURFACE_0.darker());
                                    for (int i = 1; i < 5; i++) {
                                        switch (i) {
                                            case 1 -> { //red
                                                float sliderX = pos.x + 2.5f;
                                                float sliderY = yOffset + 9;

                                                int value = c.getValue().getRed();

                                                float filledWidth = Math.min(Math.max((value - min) / (max - min), 0), 1) * maxWidth;

                                                Color clr = new Color(c.getValue().getRed(), 0, 0, 255);

                                                Renderer.drawRoundedRect(sliderX, sliderY, maxWidth, sliderHeight, sliderRadius, Mocha.SURFACE_0);
                                                Renderer.drawRoundedRect(sliderX, sliderY, filledWidth, sliderHeight, sliderRadius, clr);

                                                settingFont.drawString(TranslationUtil.getTranslation("red"), pos.x + 2, yOffset - 4, Mocha.TEXT);

                                                if (Utility.isHover(mouseX, mouseY, sliderX, sliderY, maxWidth + 2, sliderHeight)) {
                                                    float tooltipPadding = 4f;
                                                    float tooltipHeight = 10;
                                                    float tooltipRadius = 2f;
                                                    float tooltipX = mouseX - tooltipPadding;
                                                    float tooltipY = mouseY - 14;
                                                    float tooltipWidth = settingFont.getStringWidth(value + "") + 2;

                                                    Renderer.drawRoundedRect(tooltipX, tooltipY, tooltipWidth, tooltipHeight, tooltipRadius, Mocha.MANTLE.darker());
                                                    settingFont.drawXYCenteredString(value + "", tooltipX + tooltipWidth / 2f, tooltipY + tooltipHeight / 2f, Mocha.TEXT);

                                                    if (Mouse.isButtonDown(0)) {
                                                        double normalizedX = (mouseX - sliderX) / maxWidth;
                                                        double newValue = min + normalizedX * (max - min);
                                                        newValue = MathUtil.round(newValue, 0);
                                                        newValue = Math.min(Math.max(newValue, min), max);
                                                        c.setValue(new Color((int) newValue, c.getValue().getGreen(), c.getValue().getBlue(), c.getValue().getAlpha()));
                                                    }
                                                }

                                                yOffset += 22;
                                            }
                                            case 2 -> { //green
                                                float sliderX = pos.x + 2.5f;
                                                float sliderY = yOffset + 9;

                                                int value = c.getValue().getGreen();

                                                float filledWidth = Math.min(Math.max((value - min) / (max - min), 0), 1) * maxWidth;

                                                Color clr = new Color(0, c.getValue().getGreen(), 0, 255);

                                                Renderer.drawRoundedRect(sliderX, sliderY, maxWidth, sliderHeight, sliderRadius, Mocha.SURFACE_0);
                                                Renderer.drawRoundedRect(sliderX, sliderY, filledWidth, sliderHeight, sliderRadius, clr);

                                                settingFont.drawString(TranslationUtil.getTranslation("green"), pos.x + 2, yOffset - 4, Mocha.TEXT);

                                                if (Utility.isHover(mouseX, mouseY, sliderX, sliderY, maxWidth + 2, sliderHeight)) {
                                                    float tooltipPadding = 4f;
                                                    float tooltipHeight = 10;
                                                    float tooltipRadius = 2f;
                                                    float tooltipX = mouseX - tooltipPadding;
                                                    float tooltipY = mouseY - 14;
                                                    float tooltipWidth = settingFont.getStringWidth(value + "") + 2;

                                                    Renderer.drawRoundedRect(tooltipX, tooltipY, tooltipWidth, tooltipHeight, tooltipRadius, Mocha.MANTLE.darker());
                                                    settingFont.drawXYCenteredString(value + "", tooltipX + tooltipWidth / 2f, tooltipY + tooltipHeight / 2f, Mocha.TEXT);

                                                    if (Mouse.isButtonDown(0)) {
                                                        double normalizedX = (mouseX - sliderX) / maxWidth;
                                                        double newValue = min + normalizedX * (max - min);
                                                        newValue = MathUtil.round(newValue, 0);
                                                        newValue = Math.min(Math.max(newValue, min), max);
                                                        c.setValue(new Color(c.getValue().getRed(), (int) newValue, c.getValue().getBlue(), c.getValue().getAlpha()));
                                                    }
                                                }

                                                yOffset += 22;
                                            }
                                            case 3 -> { //blue
                                                float sliderX = pos.x + 2.5f;
                                                float sliderY = yOffset + 9;

                                                int value = c.getValue().getBlue();

                                                float filledWidth = Math.min(Math.max((value - min) / (max - min), 0), 1) * maxWidth;

                                                Color clr = new Color(0, 0, c.getValue().getBlue(), 255);

                                                Renderer.drawRoundedRect(sliderX, sliderY, maxWidth, sliderHeight, sliderRadius, Mocha.SURFACE_0);
                                                Renderer.drawRoundedRect(sliderX, sliderY, filledWidth, sliderHeight, sliderRadius, clr);

                                                settingFont.drawString(TranslationUtil.getTranslation("blue"), pos.x + 2, yOffset - 4, Mocha.TEXT);

                                                if (Utility.isHover(mouseX, mouseY, sliderX, sliderY, maxWidth + 2, sliderHeight)) {
                                                    float tooltipPadding = 4f;
                                                    float tooltipHeight = 10;
                                                    float tooltipRadius = 2f;
                                                    float tooltipX = mouseX - tooltipPadding;
                                                    float tooltipY = mouseY - 14;
                                                    float tooltipWidth = settingFont.getStringWidth(value + "") + 2;

                                                    Renderer.drawRoundedRect(tooltipX, tooltipY, tooltipWidth, tooltipHeight, tooltipRadius, Mocha.MANTLE.darker());
                                                    settingFont.drawXYCenteredString(value + "", tooltipX + tooltipWidth / 2f, tooltipY + tooltipHeight / 2f, Mocha.TEXT);

                                                    if (Mouse.isButtonDown(0)) {
                                                        double normalizedX = (mouseX - sliderX) / maxWidth;
                                                        double newValue = min + normalizedX * (max - min);
                                                        newValue = MathUtil.round(newValue, 0);
                                                        newValue = Math.min(Math.max(newValue, min), max);
                                                        c.setValue(new Color(c.getValue().getRed(), c.getValue().getGreen(), (int) newValue, c.getValue().getAlpha()));
                                                    }
                                                }

                                                yOffset += 22;
                                            }
                                            case 4 -> { //alpha
                                                float sliderX = pos.x + 2.5f;
                                                float sliderY = yOffset + 9;

                                                int value = c.getValue().getAlpha();

                                                float filledWidth = Math.min(Math.max((value - min) / (max - min), 0), 1) * maxWidth;

                                                Color clr = new Color(value, value, value, 255);

                                                Renderer.drawRoundedRect(sliderX, sliderY, maxWidth, sliderHeight, sliderRadius, Mocha.SURFACE_0);
                                                Renderer.drawRoundedRect(sliderX, sliderY, filledWidth, sliderHeight, sliderRadius, clr);

                                                settingFont.drawString(TranslationUtil.getTranslation("alpha"), pos.x + 2, yOffset - 4, Mocha.TEXT);

                                                if (Utility.isHover(mouseX, mouseY, sliderX, sliderY, maxWidth + 2, sliderHeight)) {
                                                    float tooltipPadding = 4f;
                                                    float tooltipHeight = 10;
                                                    float tooltipRadius = 2f;
                                                    float tooltipX = mouseX - tooltipPadding;
                                                    float tooltipY = mouseY - 14;
                                                    float tooltipWidth = settingFont.getStringWidth(value + "") + 2;

                                                    Renderer.drawRoundedRect(tooltipX, tooltipY, tooltipWidth, tooltipHeight, tooltipRadius, Mocha.MANTLE.darker());
                                                    settingFont.drawXYCenteredString(value + "", tooltipX + tooltipWidth / 2f, tooltipY + tooltipHeight / 2f, Mocha.TEXT);

                                                    if (Mouse.isButtonDown(0)) {
                                                        double normalizedX = (mouseX - sliderX) / maxWidth;
                                                        double newValue = min + normalizedX * (max - min);
                                                        newValue = MathUtil.round(newValue, 0);
                                                        newValue = Math.min(Math.max(newValue, min), max);
                                                        c.setValue(new Color(c.getValue().getRed(), c.getValue().getGreen(), c.getValue().getBlue(), (int) newValue));
                                                    }
                                                }
                                                yOffset += 3;
                                            }
                                        }
                                    }
                                }
                            }
                            case MultiSelectSetting s -> {
                                float boxHeight = 17;
                                yOffset += 16;

                                boolean hoverCB = Utility.isHover(mouseX, mouseY, pos.x - 5, yOffset, size.width, 17);
                                if (s.isExpanded()) {
                                    for (String ignored : s.getAllValues()) {
                                        boxHeight += 10;
                                    }
                                }
                                boxHeight += 12;
                                Renderer.drawRoundedSelectiveRectangle(pos.x - 5, yOffset, size.width, boxHeight, 0, Mocha.MANTLE_1.getRGB(), false, false, false, false);


                                float boxY = yOffset + 2.5f + 12;

                                float height = 12;
                                if (s.isExpanded()) {
                                    for (String ignored : s.getAllValues()) {
                                        height += 10;
                                    }
                                }

                                float boxWidth = settingFont.getStringWidth("3 " + TranslationUtil.getTranslation("enabled")) + 4 + size.width - 55;
                                float boxX = pos.x + 1;

                                Renderer.drawRoundedRect(boxX, boxY, boxWidth, height, 3, Mocha.MANTLE.brighter());
                                settingFont.drawYCenteredString(s.getName(), pos.x + 2, yOffset + 17 / 2f, hoverCB ? Mocha.TEXT.brighter() : Mocha.TEXT);
                                settingFont.drawXYCenteredString(s.stringValue(), boxX + boxWidth / 2, yOffset + 12 / 2f + 2.5f + 12, Mocha.TEXT);

                                if (s.isExpanded()) {
                                    //separator line -- if removed, clickgui breaks!@!!
                                    Renderer.drawRectangle(boxX + 2, boxY + 11, boxWidth - 4, 0.5f, Mocha.TEXT.darker());
                                    for (String val : s.getAllValues()) {
                                        yOffset += 10;
                                        boolean hoverNIGGER = Utility.isHover(mouseX, mouseY, boxX + 2, yOffset + 18, boxWidth, 9);
                                        settingFont.drawYCenteredString(val, boxX + 2, yOffset + 22, s.isEnabled(val) ? hoverNIGGER ? mainColor.brighter() : mainColor : hoverNIGGER ? Mocha.TEXT.brighter() : Mocha.TEXT);
                                    }
                                }
                                yOffset += 12;
                            }
                            case SliderSetting s -> {
                                float boxHeight = 24;
                                yOffset += 23;

                                boolean hoverCB = Utility.isHover(mouseX, mouseY, pos.x - 5, yOffset, size.width, 24);
                                Renderer.drawRoundedSelectiveRectangle(pos.x - 5, yOffset - 7, size.width, boxHeight, 4f, Mocha.MANTLE_1.getRGB(), false, false, false, false);

                                float maxWidth = 105;
                                float sliderHeight = 6;
                                float sliderRadius = 3;
                                float sliderX = pos.x + 2.5f;
                                float sliderY = yOffset + 9;

                                float value = s.getValue().floatValue();
                                float min = (float) s.min;
                                float max = (float) s.max;
                                float filledWidth = Math.min(Math.max((value - min) / (max - min), 0), 1) * maxWidth;

                                Renderer.drawRoundedRect(sliderX, sliderY, maxWidth, sliderHeight, sliderRadius, mainColor.darker());
                                Renderer.drawRoundedRect(sliderX, sliderY, filledWidth, sliderHeight, sliderRadius, mainColor);

                                settingFont.drawString(s.getName(), pos.x + 2, yOffset - 4, hoverCB ? Mocha.TEXT.brighter() : Mocha.TEXT);

                                if (Utility.isHover(mouseX, mouseY, sliderX, sliderY, maxWidth + 2, sliderHeight)) {
                                    float tooltipPadding = 4f;
                                    float tooltipHeight = 10;
                                    float tooltipRadius = 2f;
                                    float tooltipX = mouseX - tooltipPadding;
                                    float tooltipY = mouseY - 14;
                                    float tooltipWidth = settingFont.getStringWidth(s.stringValue()) + 2;

                                    Renderer.drawRoundedRect(tooltipX, tooltipY, tooltipWidth, tooltipHeight, tooltipRadius, Mocha.MANTLE.brighter());
                                    settingFont.drawXYCenteredString(s.stringValue(), tooltipX + tooltipWidth / 2f, tooltipY + tooltipHeight / 2f, Mocha.TEXT);

                                    if (Mouse.isButtonDown(0)) {
                                        double normalizedX = (mouseX - sliderX) / maxWidth;
                                        double newValue = min + normalizedX * (max - min);
                                        newValue = MathUtil.round(newValue, s.increment);
                                        newValue = Math.min(Math.max(newValue, min), max);
                                        s.setValue(newValue);
                                    }
                                }
                            }
                            default -> {
                            }
                        }
                    }
                }

                yOffset += size.height - 1;
            }
        }

        if (closing && allAnimationsDone) {
            mc.displayGuiScreen(null);
        }

        super.drawScreen(mouseX, mouseY, partialTicks);
    }

    @Override
    protected void mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        for (Category category : positions.keySet()) {
            Vector2f pos = positions.get(category);

            float yOffset = pos.y + size.height - 1;
            for (Module module : Atani.instance.moduleStorage.getModulesByCategory(category)) {
                boolean hover = Utility.isHover(mouseX, mouseY, pos.x - 5, yOffset - 5, size.width, size.height);

                if (hover) {
                    switch (mouseButton) {
                        case 0 -> module.toggle();
                        case 1 -> module.expand();
                    }
                }

                if (module.isExpanded()) {
                    for (Setting<?> setting : module.getSettings()) {
                        if (setting.getHidden().getAsBoolean()) {
                            continue;
                        }

                        switch (setting) {
                            case CheckBoxSetting cb -> {
                                yOffset += 16;
                                boolean hoverCB = Utility.isHover(mouseX, mouseY, pos.x - 5, yOffset, size.width, 17);
                                if (hoverCB && mouseButton == 0) {
                                    cb.setValue(!cb.getValue());
                                }
                            }

                            case ColorSetting c -> {
                                yOffset += 16;

                                boolean hoverCB = Utility.isHover(mouseX, mouseY, pos.x - 5, yOffset, size.width, 17);

                                if (hoverCB) {
                                    switch (mouseButton) {
                                        case 1 -> c.setExpanded(!c.isExpanded());
                                    }
                                }

                                if (c.isExpanded()) {
                                    for (int i = 1; i < 5; i++) {
                                        yOffset += 22;
                                    }
                                }
                            }

                            case StringSetting s -> {
                                yOffset += 16;
                                boolean hoverCB = Utility.isHover(mouseX, mouseY, pos.x - 5, yOffset, size.width, 17);
                                if (hoverCB) {
                                    switch (mouseButton) {
                                        case 0 -> s.next();
                                        case 1 -> s.setExpanded(!s.isExpanded());
                                    }
                                }
                            }
                            case MultiSelectSetting s -> {
                                yOffset += 16;
                                boolean hoverCB = Utility.isHover(mouseX, mouseY, pos.x - 5, yOffset, size.width, 27);

                                if (hoverCB) {
                                    switch (mouseButton) {
                                        case 0, 1 -> s.setExpanded(!s.isExpanded());
                                    }
                                }

                                float boxPadding = 7f;

                                float boxWidth = settingFont.getStringWidth(s.stringValue()) + 4 + size.width - 55;
                                float boxX = pos.x + size.width - boxWidth - boxPadding - 5.5f;

                                if (s.isExpanded()) {
                                    for (String val : s.getAllValues()) {
                                        yOffset += 10;
                                        if (Utility.isHover(mouseX, mouseY, boxX + 2, yOffset + 18, boxWidth, 9)) {
                                            List<String> values = new ArrayList<>(Arrays.asList(s.getValue()));

                                            if (s.isEnabled(val)) {
                                                values.remove(val);
                                            } else {
                                                values.add(val);
                                            }

                                            s.setValue(values.toArray(new String[0]));
                                        }
                                    }
                                }
                                yOffset += 12;
                            }
                            case SliderSetting s -> {
                                yOffset += 23;
                            }
                            default -> {
                            }
                        }

                        boolean hoverSetting = Utility.isHover(mouseX, mouseY, pos.x - 5, yOffset, size.width, 17);
                        if (hoverSetting) {
                            focusedSetting = setting;
                        }
                    }
                }

                yOffset += size.height - 1;
            }
        }
        super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    private Category draggingCategory = null;
    private float offsetX, offsetY;

    private Vector2f drag(float mouseX, float mouseY, Category category, Vector2f pos) {
        if (Mouse.isButtonDown(0)) {
            if (draggingCategory == null && Utility.isHover(mouseX, mouseY, pos.x, pos.y, size.width, size.height)) {
                draggingCategory = category;
                offsetX = mouseX - pos.x;
                offsetY = mouseY - pos.y;
            }

            if (draggingCategory == category) {
                baseYPositions.put(category, mouseY - offsetY); // Update base Y instead of direct pos.y
                pos.x = mouseX - offsetX;
            }
        } else {
            draggingCategory = null;
        }

        return pos;
    }

    @Override
    protected void keyTyped(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            closing = true;
        } else {
            if (focusedSetting != null) {
                if (focusedSetting instanceof SliderSetting s) {
                    switch (keyCode) {
                        case 203 -> { // left
                            double smallestValue = Math.pow(10, -s.increment);
                            double newValue = MathUtil.round(s.getValue() - smallestValue, s.increment);
                            s.setValue(newValue);
                        }
                        case 205 -> { // right
                            double smallestValue = Math.pow(10, -s.increment);
                            double newValue = MathUtil.round(s.getValue() + smallestValue, s.increment);
                            s.setValue(newValue);
                        }
                    }
                }
            }

            super.keyTyped(typedChar, keyCode);
        }
    }

    @Override
    public void onGuiClosed() {
        Keyboard.enableRepeatEvents(false);
        ThreadUtil.runAsync(() -> {
            Atani.instance.fileStorage.getT(ModuleFile.class).save();
            Atani.instance.fileStorage.getT(KeybindFile.class).save();

            if (Atani.instance.fileStorage.config.has("Modern CGUI")) {
                Atani.instance.fileStorage.config.remove("Modern CGUI");
            }

            JsonObject modernCGUI = new JsonObject();

            for (Category category : positions.keySet()) {
                JsonObject pos = new JsonObject();
                pos.addProperty("X", positions.get(category).x);
                pos.addProperty("Y", baseYPositions.get(category));

                modernCGUI.add(category.getName(), pos);
            }

            Atani.instance.fileStorage.config.add("Modern CGUI", modernCGUI);
        });
    }
}
