package tech.atani.client.screen.clickGui;

import com.google.gson.JsonObject;
import net.minecraft.client.gui.GuiScreen;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import tech.atani.client.Atani;
import tech.atani.client.file.impl.KeybindFile;
import tech.atani.client.file.impl.ModuleFile;
import tech.atani.client.module.data.Category;
import tech.atani.client.screen.clickGui.etc.CategoryPanel;
import tech.atani.client.util.game.render.font.gui.font.renderer.SimpleFontRenderer;
import tech.atani.client.util.system.thread.ThreadUtil;
import tech.atani.client.util.game.render.catppuccin.Mocha;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClickGuiScreen extends GuiScreen {
    private final List<CategoryPanel> panels = new ArrayList<>();
    private final Map<Category, Float> baseYPositions = new HashMap<>();
    private final SimpleFontRenderer titleFont = Atani.instance.fontStorage.getFont("Google-Medium", 14).newRenderer();
    private final SimpleFontRenderer bodyFont = Atani.instance.fontStorage.getFont("Google-Regular", 12).newRenderer();
    private final SimpleFontRenderer smallFont = Atani.instance.fontStorage.getFont("Google-Regular", 10).newRenderer();
    private final Color primaryColor = Mocha.MAUVE;
    private final Color surfaceColor = Mocha.SURFACE_0;
    private final Color onSurfaceColor = Mocha.SUBTEXT_1;
    private final Color secondaryColor = Mocha.TEAL;
    private boolean closing = false;
    private final float panelWidth = 120;
    private final float panelHeight = 22;
    private final float padding = 2;
    private float scrollOffset = 0;
    private float maxScrollOffset = 0;

    public ClickGuiScreen() {
        float xOffset = 10;

        if (Atani.instance.fileStorage.config.has("Modern CGUI")) {
            JsonObject cguiObj = Atani.instance.fileStorage.config.getAsJsonObject("Modern CGUI");
            for (Category category : Category.values()) {
                JsonObject catObj = cguiObj.has(category.getName()) ? cguiObj.getAsJsonObject(category.getName()) : null;
                if (catObj != null) {
                    float y = catObj.get("Y").getAsFloat();
                    panels.add(new CategoryPanel(category, catObj.get("X").getAsFloat(), y));
                    baseYPositions.put(category, y);
                }
            }
        } else {
            for (Category category : Category.values()) {
                panels.add(new CategoryPanel(category, xOffset, 10));
                baseYPositions.put(category, 10f);
                xOffset += panelWidth + padding;
            }
        }
    }

    @Override
    public void initGui() {
        closing = false;
        scrollOffset = 0;
        Keyboard.enableRepeatEvents(true);
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        float totalHeight = 0;
        for (CategoryPanel panel : panels) {
            panel.updateHeight();
            totalHeight = Math.max(totalHeight, panel.getY() + panel.getHeight());
        }
        maxScrollOffset = Math.max(0, totalHeight - height + 20);

        int wheel = Mouse.getDWheel();
        if (wheel != 0) {
            scrollOffset -= wheel * 2.0f;
            scrollOffset = Math.max(0, Math.min(scrollOffset, maxScrollOffset));
        }

        for (CategoryPanel panel : panels) {
            Category category = panel.getCategory();
            float targetY = closing ? -panelHeight - 80 : baseYPositions.get(category) - scrollOffset;
            panel.setY(targetY);

            if (panel.getY() + panel.getHeight() >= 0 && panel.getY() <= height) {
                panel.draw(mouseX, mouseY, partialTicks, titleFont, bodyFont, smallFont, primaryColor, surfaceColor, onSurfaceColor, secondaryColor);
            }
        }

        if (closing) {
            mc.displayGuiScreen(null);
        }
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        for (CategoryPanel panel : panels) {
            if (panel.getY() + panel.getHeight() >= 0 && panel.getY() <= height) {
                panel.mouseClicked(mouseX, mouseY, mouseButton);
            }
        }
    }

    @Override
    public void mouseReleased(int mouseX, int mouseY, int mouseButton) {
        for (CategoryPanel panel : panels) {
            if (panel.getY() + panel.getHeight() >= 0 && panel.getY() <= height) {
                panel.mouseReleased(mouseX, mouseY, mouseButton);
            }
        }
    }

    @Override
    public void keyTyped(char typedChar, int keyCode) {
        if (keyCode == 1) {
            closing = true;
        }
    }

    @Override
    public void onGuiClosed() {
        Keyboard.enableRepeatEvents(false);
        ThreadUtil.runAsync(() -> {
            Atani.instance.fileStorage.getT(ModuleFile.class).save();
            Atani.instance.fileStorage.getT(KeybindFile.class).save();

            if (Atani.instance.fileStorage.config.has("Modern CGUI")) {
                Atani.instance.fileStorage.config.remove("Modern CGUI");
            }

            JsonObject modernCGUI = new JsonObject();
            for (CategoryPanel panel : panels) {
                Category category = panel.getCategory();
                JsonObject pos = new JsonObject();
                pos.addProperty("X", panel.getX());
                pos.addProperty("Y", baseYPositions.get(category));
                modernCGUI.add(category.getName(), pos);
            }
            Atani.instance.fileStorage.config.add("Modern CGUI", modernCGUI);
        });
    }

    @Override
    public boolean doesGuiPauseGame() {
        return false;
    }
}