package tech.atani.client.screen.altManager;

import tech.atani.client.file.impl.AccountFile;
import tech.atani.client.screen.mainMenu.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import tech.atani.client.Atani;
import tech.atani.client.util.Util;
import tech.atani.client.util.client.language.TranslationUtil;
import tech.atani.client.util.game.render.Utility;
import tech.atani.client.util.game.render.animation.Animation;
import tech.atani.client.util.game.render.animation.EnumTransition;
import tech.atani.client.util.game.render.catppuccin.Mocha;
import tech.atani.client.util.game.render.font.gui.font.renderer.SimpleFontRenderer;
import tech.atani.client.util.game.render.shader.data.renderer.Renderer;
import tech.atani.client.util.system.thread.ThreadUtil;

import java.awt.*;
import java.io.IOException;

/**
 * Finally an alt manager
 */
public class GuiAltManager extends GuiScreen {
    private final SimpleFontRenderer logoFont = Atani.instance.fontStorage.getFont("SFPT-Semibold", 36).newRenderer();
    private final Animation scrollAnimation = new Animation(0, EnumTransition.SQRT, 1f);
    private final AltManagerGuiButtons addAltButton;
    private float scroll = 50f;

    private final GuiMainMenu parent;

    public GuiAltManager(GuiMainMenu parent) {
        this.parent = parent;
        this.addAltButton = new AltManagerGuiButtons(parent);
    }

    @Override
    public void handleMouseInput() throws IOException {
        if (!addAltButton.add) {
            int scrollAmount = Mouse.getEventDWheel();

            if (scrollAmount != 0) {
                if (scrollAmount > 0) {
                    scroll += 50;
                } else {
                    scroll -= 50;
                }

                scroll = Math.min(scroll, (float) height / 2 - 25);
            }
        }

        super.handleMouseInput();
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTicks) {

        scrollAnimation.update(scroll);
        Renderer.drawNoiseRectangle(0, 0, width, height, Mocha.CRUST, Mocha.BASE, 0.02f);

        float y = scrollAnimation.getValue();
        for (Account account : Atani.instance.accountStorage.getSet()) {
            account.getButton().draw((float) width / 2, y, addAltButton.add ? 0 : mouseX, addAltButton.add ? 0 : mouseY);
            y += account.getButton().getHeight() + 5;
        }

        float h = (float)(height / 2);

        Color[] colors = new Color[]{
                Color.black,
                Color.black,
        };

        addAltButton.draw(10, height - 90, mouseX, mouseY);

        logoFont.drawXCenteredString(TranslationUtil.getTranslation("altmanager.alts"), (float) width / 2, 10, Mocha.TEXT);
    }

    @Override
    protected void mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (!addAltButton.add) {
            for (Account account : Atani.instance.accountStorage.getSet()) {
                account.getButton().clicked(mouseX, mouseY, mouseButton);
            }
        }

        addAltButton.clicked(mouseX, mouseY, mouseButton);
    }

    @Override
    protected void keyTyped(char typedChar, int keyCode) throws IOException {
        if (keyCode == Keyboard.KEY_ESCAPE) {
            mc.displayGuiScreen(parent);
        } else {
            addAltButton.typed(typedChar, keyCode);
        }
    }

    @Override
    public void onGuiClosed() {
        ThreadUtil.runAsync(() -> {
            Atani.instance.fileStorage.getT(AccountFile.class).save();
        });
    }
}
