package tech.atani.client.screen.altManager;

import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.entity.Render;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import tech.atani.client.Atani;
import tech.atani.client.util.client.interfaces.IMinecraft;
import tech.atani.client.util.client.language.TranslationUtil;
import tech.atani.client.util.game.render.animation.Animation;
import tech.atani.client.util.game.render.catppuccin.Mocha;
import tech.atani.client.util.game.render.font.gui.font.formatting.impl.NoFormattingProcessor;
import tech.atani.client.util.game.render.font.gui.font.renderer.SimpleFontRenderer;
import tech.atani.client.util.game.render.shader.data.renderer.Renderer;

/**
 * Serves as an input panel for the alt managers microsoft login
 * @author marie
 */
public class AltMangerGuiButtonsStringInputPanel implements IMinecraft {

    private static final SimpleFontRenderer NAME_FONT = Atani.instance.fontStorage.getFont("SFPT-Bold", 12).newRenderer();
    private static final SimpleFontRenderer INPUT_FONT = Atani.instance.fontStorage.getFont("SFPT-Light", 10).newRenderer(new NoFormattingProcessor());
    private final Animation cursorAnimation = new Animation(0, 1f);
    private float posX, posY, posW, posH;
    private final boolean isPassword;
    private final String title;

    public boolean selected = false;
    public final StringBuilder sb = new StringBuilder();

    public AltMangerGuiButtonsStringInputPanel(String title, boolean isPassword) {
        this.title = TranslationUtil.getTranslation(title);
        this.isPassword = isPassword;
    }

    public void draw(float x, float y, float w, float h) {

        posX = x;
        posY = y + 4;
        posW = w;
        posH = h;

        NAME_FONT.drawYCenteredString(title, posX + 2, posY, Mocha.TEXT);
        posY += NAME_FONT.getFontHeight();
        Renderer.drawRectangle(posX, posY, posW, posH, Mocha.SURFACE_1);

        GL11.glPushMatrix();
        GL11.glEnable(GL11.GL_SCISSOR_TEST);
        ScaledResolution sr = new ScaledResolution(mc);
        float scale = sr.getScaleFactor();
        GL11.glScissor((int) (posX * scale), (int) ((sr.getScaledHeight() - posY - (NAME_FONT.getFontHeight() * scale)) * scale + 8), (int) (posW * scale), (int) (posH * scale));

        String renderString = isPassword ? "*".repeat(sb.length()) : sb.toString();

        cursorAnimation.update(INPUT_FONT.getStringWidth(renderString) + 3);

        if (selected) {
            Renderer.drawRoundedRect(posX + cursorAnimation.getValue(), posY+2, 1, posH-4, 1, Mocha.TEXT);
        }

        INPUT_FONT.drawYCenteredString(renderString, posX + 2, posY + (posH/2), Mocha.TEXT);
        GL11.glDisable(GL11.GL_SCISSOR_TEST);
        GL11.glPopMatrix();
    }

    public void keyPressed(char character, int code) {
        if (selected) {
            if (code == Keyboard.KEY_BACK) {
                if (!sb.isEmpty()) {
                    sb.deleteCharAt(sb.length() - 1);
                }
            } else if (character >= 32 && character != 127) {
                sb.append(character);
            }
        }
    }

    public void onClick(int mouseX, int mouseY) {
        selected = isHovered(mouseX, mouseY);
    }

    private boolean isHovered(int mouseX, int mouseY) {
        return mouseX >= posX && mouseY >= posY && mouseX < posX + posW && mouseY < posY + posH;
    }
}
