package tech.atani.client.screen.altManager;

import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.util.Session;
import tech.atani.CookieLogin;
import tech.atani.MicrosoftLogin;
import tech.atani.client.Atani;
import tech.atani.client.screen.Icon;
import tech.atani.client.screen.mainMenu.GuiMainMenu;
import tech.atani.client.util.client.interfaces.IMinecraft;
import tech.atani.client.util.client.language.TranslationUtil;
import tech.atani.client.util.game.render.animation.Animation;
import tech.atani.client.util.game.render.animation.EnumTransition;
import tech.atani.client.util.game.render.catppuccin.Mocha;
import tech.atani.client.util.game.render.font.gui.font.renderer.SimpleFontRenderer;
import tech.atani.client.util.game.render.shader.data.renderer.Renderer;

import java.awt.*;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.net.URI;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

/**
 * 2-in-1 button + full login gui
 * @author Marie
 */
public class AltManagerGuiButtons implements IMinecraft {
    private static final SimpleFontRenderer NAME_FONT = Atani.instance.fontStorage.getFont("SFPT-Bold", 12).newRenderer();
    private static final SimpleFontRenderer STATUS_FONT = Atani.instance.fontStorage.getFont("SFPT-Light", 10).newRenderer();
    private static final SimpleFontRenderer ICON_FONT = Atani.instance.fontStorage.getFont("Icons-FilledRounded", 24).newRenderer();
    private static final AtomicReference<String> browserStatus = new AtomicReference<>("");
    private static AltMangerGuiButtonsStringInputPanel msEmail;
    private static AltMangerGuiButtonsStringInputPanel msPassword;
    private HoverType lastType = HoverType.BACK;
    private final GuiMainMenu parent;
    private final float height = 80f;
    private final float width = 40f;
    private boolean hovered;
    public boolean add;

    private final Animation hoverAnim = new Animation(0, EnumTransition.SQRT, 1f);
    private final Animation addAnim = new Animation(100, EnumTransition.SQRT, 1f);
    private final Animation addSwitchIconAnim = new Animation(0, EnumTransition.SQRT, 1f);

    private float newX;
    private float newY;
    private float newW;
    private float newH;

    private AddType addType = AddType.COOKIE;


    public AltManagerGuiButtons(GuiMainMenu parent) {
        this.parent = parent;
        msEmail = new AltMangerGuiButtonsStringInputPanel("altmanager.add.email", false);
        msPassword = new AltMangerGuiButtonsStringInputPanel("altmanager.add.password", true);
    }

    public void draw(float x, float y, int mouseX, int mouseY) {
        ScaledResolution sr = new ScaledResolution(mc); // fuck ram usage atp I just want to go to sleep

        double mid_w = sr.getScaledWidth_double() / 2d;
        double mid_h = sr.getScaledHeight_double() / 2d;

        float halfWidth = width * 0.5f;
        float halfHeight = height * 0.5f;

        float anim = addAnim.getValue() / 100;

        float rx = (float) (mid_w - halfWidth - ((mid_w - 10 - halfWidth) * anim) + ((halfWidth + 5) * (1 - anim)));
        float ry = (float) (mid_h + halfHeight + ((mid_h - 90 - halfHeight) * anim) - (halfHeight * (1 - anim)));

        float newWidth = 200 * (1 - anim);
        float newHeight = 150 * (1 - anim);

        newX = rx - (newWidth / 2);
        newY = ry - newHeight;
        newW = width + (newWidth/4*3);
        newH = height + newHeight;
        hovered = isHovered(mouseX, mouseY, newX, newY, newW, newH);

        if (!add) {
            addAnim.update(100);

            float moreHalfHeight = height * 1.5f; // dont ask
            //hovered = mouseX >= x - width && mouseY >= y && mouseX < x + width && mouseY < y + height;
            HoverType type = hovered ? (mouseY - y) < halfHeight ? HoverType.ACCOUNT : HoverType.BACK : null;

            if (type != null) {
                lastType = type;
                hoverAnim.update(type.y);
            } else {
                hoverAnim.update(0);
            }

            float a = Math.max(0.0f, Math.min(1.0f, hoverAnim.getValue() / 100));

            if (a > 0.1) {
                Color textColor = new Color((float) Mocha.TEXT.getRed() / 255, (float) Mocha.TEXT.getGreen() / 255, (float) Mocha.TEXT.getBlue() / 255, a);
                NAME_FONT.drawYCenteredString(TranslationUtil.getTranslation(lastType.s), x + width + 5, (y + height) - (halfHeight * (hoverAnim.getValue() / 100) - (halfHeight / 2)), textColor);
            }

            Renderer.drawRoundedRect(newX, newY, newW, newH, 5f, Mocha.SURFACE_0);
            
            ICON_FONT.drawXYCenteredString(Icon.ADD_ALT.letter, x + width / 2, y + halfHeight / 2, Mocha.TEXT);
            ICON_FONT.drawXYCenteredString(Icon.BACK.letter, x + width / 2, y + moreHalfHeight / 2, Mocha.TEXT);
        } else {
            addAnim.update(0);
            addSwitchIconAnim.update(addType.x);

            Renderer.drawRectangle(0, 0, sr.getScaledWidth(), sr.getScaledHeight(), new Color(0, 0, 0, 100));

            Renderer.drawRoundedRect(newX, newY, newW, newH, 5f, Mocha.SURFACE_0);

            Renderer.drawRoundedRect(newX, newY, newW, newH / 5, 5f, Mocha.SURFACE_1);
            // the holy math that holds this animation together LMAO
            Renderer.drawRoundedRect((float) (newX + ((newH / 25) * ((addSwitchIconAnim.getValue() / 14.5) + 1))), newY, newH / 5, newH / 5, 5f, Mocha.SURFACE_2);
            Renderer.drawRoundedRect(newX, newY + (newH / 5 * 4), newW, newH / 5, 5f, Mocha.SURFACE_1);

            NAME_FONT.drawXYCenteredString(addType.text.get(), newX + (newW / 2), newY + (newH / 10 * 9), Mocha.TEXT);

            ICON_FONT.drawXYCenteredString(Icon.COOKIE.letter, newX + (newW / 6), newY + newH / 10, Mocha.TEXT);
            ICON_FONT.drawXYCenteredString(Icon.BROWSER.letter, newX + (newW / 6 * 3), newY + newH / 10, Mocha.TEXT);
            ICON_FONT.drawXYCenteredString(Icon.GRID.letter, newX + (newW / 6 * 5), newY + newH / 10, Mocha.TEXT);

            switch (addType) {
                case BROWSER -> {
                    STATUS_FONT.drawYCenteredString(browserStatus.get(), newX + 5, newY + (newH / 2), Mocha.TEXT);
                }
                case COOKIE -> {
                    STATUS_FONT.drawYCenteredString(TranslationUtil.getTranslation("notimplemented"), newX + 5, newY + (newH / 2), Mocha.TEXT);
                }
                case MICROSOFT -> {
                    msEmail.draw(newX + 0.5f, newY + (newH / 4), newW - 0.5f, newH / 10);
                    msPassword.draw(newX + 0.5f, newY + (newH / 2), newW - 0.5f, newH / 10);
                }
            }
        }
    }

    public void clicked(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0) {
            if (!add) {
                if (hovered) {
                    switch (lastType) {
                        case BACK -> mc.displayGuiScreen(parent);
                        case ACCOUNT -> add = true;
                    }
                }
            } else {
                if (hovered) {
                    if (isHovered(mouseX, mouseY, newX + (newW / 6) - ICON_FONT.getFontHeight(), newY + newH / 10 - ICON_FONT.getFontHeight(), ICON_FONT.getFontHeight() * 2, ICON_FONT.getFontHeight() * 2)) {
                        addType = AddType.COOKIE;
                    } else if (isHovered(mouseX, mouseY, newX + (newW / 6 * 3) - ICON_FONT.getFontHeight(), newY + newH / 10 - ICON_FONT.getFontHeight(), ICON_FONT.getFontHeight() * 2, ICON_FONT.getFontHeight() * 2)) {
                        addType = AddType.BROWSER;
                    } else if (isHovered(mouseX, mouseY, newX + (newW / 6 * 5) - ICON_FONT.getFontHeight(), newY + newH / 10 - ICON_FONT.getFontHeight(), ICON_FONT.getFontHeight() * 2, ICON_FONT.getFontHeight() * 2)) {
                        addType = AddType.MICROSOFT;
                    } else if (isHovered(mouseX, mouseY, newX, newY + (newH / 5 * 4), newW, newH / 5)) {
                        addType.onClick.run();
                    } else if (addType == AddType.MICROSOFT) {
                        msEmail.onClick(mouseX, mouseY);
                        msPassword.onClick(mouseX, mouseY);
                    }
                } else {
                    add = false;
                }
            }
        }
    }

    private static boolean isHovered(int mouseX, int mouseY, float x, float y, float w, float h) {
        return mouseX >= x && mouseY >= y && mouseX < x + w && mouseY < y + h;
    }

    public void typed(char typedChar, int keyCode) {
        if (addType == AddType.MICROSOFT) {
            msEmail.keyPressed(typedChar, keyCode);
            msPassword.keyPressed(typedChar, keyCode);
        }
    }

    public enum HoverType {
        BACK(100, "altmanager.back"),
        ACCOUNT(200, "altmanager.add");

        public final float y;
        public final String s;

        HoverType(float y, String s) {
            this.y = y;
            this.s = s;
        }
    }

    public enum AddType {
        COOKIE(0, () -> TranslationUtil.getTranslation("altmanager.cookie.select"), () -> {
            Session session = CookieLogin.login();
            if (session != null) {
                Atani.instance.accountStorage.add(new Account(session.getUsername(), session.getPlayerID(), session.getToken()));
            }
        }),
        BROWSER(100, () -> TranslationUtil.getTranslation("altmanager.browser.launch"), () -> {
            ExecutorService executor = Executors.newSingleThreadExecutor();
            MicrosoftLogin.acquireMSAuthCode(uri -> {
                try {
                    final Class<?> desktop = Class.forName("java.awt.Desktop");
                    final Object object = desktop.getMethod("getDesktop").invoke(null);

                    desktop.getMethod("browse", URI.class).invoke(object, uri);
                } catch (Throwable throwable) {
                    StringSelection selection = new StringSelection(uri.toString());
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(selection, selection);
                    browserStatus.set(TranslationUtil.getTranslation("altmanager.browser.couldntopen"));
                }
            }, executor)
                    .thenComposeAsync(msAuthCode -> {
                        browserStatus.set(TranslationUtil.getTranslation("altmanager.browser.progress.authcode"));
                        return MicrosoftLogin.acquireMSAccessToken(msAuthCode, executor);
                    }, executor)
                    .thenComposeAsync(msAccessToken -> {
                        browserStatus.set(TranslationUtil.getTranslation("altmanager.browser.progress.msaccesstoken"));
                        return MicrosoftLogin.acquireXboxAccessToken(msAccessToken, executor);
                    }, executor)
                    .thenComposeAsync(xboxAccessToken -> {
                        browserStatus.set(TranslationUtil.getTranslation("altmanager.browser.progress.xboxaccesstoken"));
                        return MicrosoftLogin.acquireXboxXstsToken(xboxAccessToken, executor);
                    }, executor)
                    .thenComposeAsync(xboxXstsData -> {
                        browserStatus.set(TranslationUtil.getTranslation("altmanager.browser.progress.xboxxsts"));
                        return MicrosoftLogin.acquireMCAccessToken(xboxXstsData.get("Token"), xboxXstsData.get("uhs"), executor);
                    }, executor)
                    .thenComposeAsync(mcToken -> {
                        browserStatus.set(TranslationUtil.getTranslation("altmanager.browser.progress.login"));
                        return MicrosoftLogin.login(mcToken, executor);
                    }, executor)
                    .thenAccept(session -> {
                        Atani.instance.accountStorage.add(new Account(session.getUsername(), session.getPlayerID(), session.getToken()));
                        browserStatus.set(String.format(TranslationUtil.getTranslation("altmanager.browser.success"), session.getUsername()));
                    })
                    .exceptionally(error -> {
                        browserStatus.set(String.format(TranslationUtil.getTranslation("altmanager.browser.error"), error.getMessage()));
                        return null;
                    });
        }),
        MICROSOFT(200, () -> TranslationUtil.getTranslation("altmanager.add"), () -> {
            Atani.instance.accountStorage.add(new Account(msEmail.sb.toString().trim(), msPassword.sb.toString().trim()));
        });

        public final float x;
        public final Supplier<String> text;
        public final Runnable onClick;

        AddType(float x, Supplier<String> text, Runnable onClick) {
            this.onClick = onClick;
            this.text = text;
            this.x = x;
        }
    }
}
