package tech.atani.client.screen.altManager;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.Setter;
import tech.atani.client.Atani;
import tech.atani.client.util.game.render.animation.Animation;
import tech.atani.client.util.game.render.animation.EnumTransition;
import tech.atani.client.util.game.render.catppuccin.Mocha;
import tech.atani.client.util.game.render.font.gui.font.renderer.SimpleFontRenderer;
import tech.atani.client.util.game.render.shader.data.renderer.Renderer;

/**
 * Basically just a button that expands when hovered to show more info
 */
@Getter
@Setter
@AllArgsConstructor
public class AccountButton {
    private static final SimpleFontRenderer NAME_FONT = Atani.instance.fontStorage.getFont("SFPT-Bold", 16).newRenderer();
    private static final SimpleFontRenderer ICON_FONT = Atani.instance.fontStorage.getFont("Icons-FilledRounded", 36).newRenderer();
    private final float width = 400f;
    private final float height = 50f;
    private final Account account;
    private boolean expanded;
    private boolean hovered;

    private final Animation hoverAnim = new Animation(0, EnumTransition.SQRT, 1f);

    public void draw(float x, float y, int mouseX, int mouseY) {
        float halfWidth = width / 2;
        hovered = mouseX >= x - halfWidth && mouseY >= y && mouseX < x + halfWidth + hoverAnim.getValue() && mouseY < y + height;

        hoverAnim.update(hovered ? 30 : 0);

        x += hoverAnim.getValue();

        Renderer.drawRoundedRect(
                x - halfWidth,
                y,
                width,
                height,
                5f,
                Mocha.SURFACE_0
        );

        Renderer.drawRoundedRect(
                x - halfWidth,
                y,
                height,
                height,
                5f,
                account.getType().c
        );

        ICON_FONT.drawXYCenteredString(account.getType().i.letter, x - halfWidth + height / 2, y + height / 2, Mocha.SURFACE_0);

        NAME_FONT.drawString(account.getName(), x - halfWidth + height + 10, y + 5, Mocha.TEXT);
    }

    public void clicked(int mouseX, int mouseY, int mouseButton) {
        if (hovered && mouseButton == 0) {
            account.login();
        }
    }
}
