package tech.atani.client.screen.altManager;

import fr.litarvan.openauth.microsoft.MicrosoftAuthResult;
import fr.litarvan.openauth.microsoft.MicrosoftAuthenticator;
import lombok.Getter;
import lombok.Setter;
import net.minecraft.util.Session;
import tech.atani.client.util.client.interfaces.ILogger;
import tech.atani.client.util.client.interfaces.IMinecraft;
import tech.atani.client.util.game.render.Utility;

@Getter
@Setter
public class Account implements IMinecraft {
    private transient final AccountButton button = new AccountButton(this, false, false);
    private final EnumAccountType type;
    private final String name;

    private String token = "",
            password = "",
            skin = Utility.getSteveHead();

    /**
     * Custom account, name only
     * @param type The type of the account
     * @param name The name of the account
     */
    public Account(EnumAccountType type, String name) {
        this.type = type;
        this.name = name;
    }

    /**
     * Microsoft email account
     * @param email The email of the account
     * @param password The password of the account
     */
    public Account(String email, String password) {
        if (password.isEmpty()) {
            this.type = EnumAccountType.CRACKED;
        } else {
            this.type = EnumAccountType.MICROSOFT;
        }
        this.name = email;
        this.password = password;
    }

    /**
     * Cracked account
     * @param name The name of the account
     */
    public Account(String name) {
        this.type = EnumAccountType.CRACKED;
        this.name = name;
    }

    /**
     * Microsoft token account
     * @param name The name of the account
     * @param uuid The uuid of the account
     * @param token The session token of the account
     */
    public Account(String name, String uuid, String token) {
        this.type = EnumAccountType.MICROSOFT;
        this.name = name;
        this.password = uuid;
        this.token = token;
    }

    /**
     * Checks if the account is a valid Microsoft/premium account
     * @return Returns if the account is a Microsoft/premium account or not
     */
    public boolean isPremium() {
        return name.contains("@") || !token.isEmpty() || !password.isEmpty();
    }

    /**
     * Checks if the account is a cracked/offline account
     * @return Returns if the account is a cracked/offline account
     */
    public boolean isCracked() {
        return password.isEmpty() && !name.contains("@") && token.isEmpty();
    }

    /**
     * Nigga
     */
    public void login() {
        if (type == EnumAccountType.MICROSOFT) {
            if (token.isEmpty()) {
                try {
                    System.out.println("took nigga auth route");
                    MicrosoftAuthenticator authenticator = new MicrosoftAuthenticator();
                    MicrosoftAuthResult result = authenticator.loginWithCredentials(name, password);

                    mc.setSession(new Session(result.getProfile().getName(), result.getProfile().getId(), result.getAccessToken(), "msa"));
                } catch (Throwable t) {
                    t.printStackTrace();
                }
            } else {
                mc.setSession(new Session(name, password, token, "msa"));
            }
        } else if (type == EnumAccountType.CRACKED) {
            mc.setSession(new Session(name, "0", "0", "mojang"));
        }
        ILogger.logger.info("Logged in as {} ({} alt)", name, type.name().toLowerCase());
    }
}
