package tech.atani.client.screen;

import tech.atani.client.module.data.Category;
import tech.atani.client.screen.vec.IconVector;

public class IconUtil {

    public static IconVector getCategoryIcon(Category category) {
        switch (category) {
            case COMBAT -> {
                return new IconVector(0, 2, Icon.COMBAT);
            }
            case MOVEMENT -> {
                return new IconVector(0, 2, Icon.MOVEMENT);
            }
            case PLAYER -> {
                return new IconVector(0, 2, Icon.PERSON);
            }
            case RENDER -> {
                return new IconVector(0, 2, Icon.RENDER);
            }
            case HUD -> {
                return new IconVector(0, 2, Icon.MONITOR);
            }
            case CLIENT -> {
                return new IconVector(0, 2, Icon.CLIENT);
            }
            case SCRIPT -> {
                return new IconVector(0, 2, Icon.FOLDER);
            }
            default -> {
                return new IconVector(2, 2, Icon.EXIT);
            }
        }
    }

}
