package tech.atani.client.screen;

import java.util.Arrays;
import java.util.Objects;

public enum Icon {
    CLIENT("A", "client", "3d box"),
    EXIT("B", "close", "x", "missing", "exit"),
    COMBAT("C", "combat", "pvp", "swords"),
    HOME("D", "home", "house"),
    MONITOR("E", "monitor", "tv", "hud"),
    MINUS("F", "minus", "minimise"),
    MOVEMENT("G", "movement", "sprinting", "running"),
    PERSON("H", "person", "player", "user", "singleplayer"),
    RENDER("I", "render", "eye", "pupil"),
    SETTINGS("J", "settings", "cog wheel"),
    GRIP("K", "grip", "drag", "scale"),
    ADD("L", "add", "circle add"),
    CHECK("M", "check", "circle check"),
    CANCEL("N", "cancel", "circle cancel", "circle x"),
    MENU("O", "menu", "select"),
    LOGIN("P", "login"),
    LOGOUT("Q", "logout"),
    PIN("R", "pin", "location"),
    PIN_DROP("S", "pin drop", "location drop"),
    ARROW("T", "arrow", "mouse", "airplane"),
    DRAG("U", "drag"),
    MULTIPLE_PEOPLE("V", "multiplayer", "multi user", "multiple people"),
    MANAGE_PEOPLE("W", "manage people", "manage user", "alt manager"),
    COOKIE("X", "cookie", "cookie alt", "cookie login"),
    BACK("Y", "back", "go back", "reply"),
    REMOVE_ALT("Z", "remove alt", "delete alt"),
    ADD_ALT("a", "add alt", "new alt"),
    BROWSER("b", "browser", "chrome", "internet"),
    GRID("c", "grid", "grid view", "microsoft"),
    CHECK_ALT("d", "check alt", "check person"),
    EDIT_ALT("e", "edit alt", "modify alt", "rename alt"),
    CRACKED("f", "cracked", "cracked alt", "cloud off"),
    FOLDER("g", "folder", "open folder");

    public final String letter;
    public final String[] alias;

    Icon(String letter, String... alias) {
        this.letter = letter;
        this.alias = alias;
    }

    public static Icon getByLetter(String letter) {
        for (Icon icon : values()) {
            if (icon.letter.equalsIgnoreCase(letter)) {
                return icon;
            }
        }
        return EXIT;
    }

    public static Icon getByAlias(String alias) {
        for (Icon icon : values()) {
            for (String a : icon.alias) {
                if (a.equalsIgnoreCase(alias)) {
                    return icon;
                }
            }
        }
        return EXIT;
    }

    public static String[] getFirstAliases() {
        return Arrays.stream(values())
                .map(icon -> icon.alias.length > 0 ? icon.alias[0] : null)
                .filter(Objects::nonNull)
                .toArray(String[]::new);
    }
}
