package tech.atani.client.module.scripting;

import tech.atani.client.util.client.interfaces.ILogger;

import java.util.regex.Pattern;

public class ScriptAPIValidator implements ILogger {
    private static final Pattern[] BLACKLISTED_PATTERNS = {
            Pattern.compile("os\\.execute", Pattern.LITERAL),
            Pattern.compile("os\\.remove", Pattern.LITERAL),
            Pattern.compile("os\\.rename", Pattern.LITERAL),
            Pattern.compile("os\\.tmpname", Pattern.LITERAL),
            Pattern.compile("os\\.getenv", Pattern.LITERAL),
            Pattern.compile("os\\.setenv", Pattern.LITERAL),
            Pattern.compile("io\\.popen", Pattern.LITERAL),
            Pattern.compile("io\\.open", Pattern.LITERAL),
            Pattern.compile("loadstring", Pattern.LITERAL),
            Pattern.compile("load", Pattern.LITERAL),
            Pattern.compile("require\\(['\"]ffi['\"]\\)", Pattern.LITERAL),
            Pattern.compile("java\\.lang\\.Runtime", Pattern.LITERAL),
            Pattern.compile("System\\.exit", Pattern.LITERAL),
            Pattern.compile("ProcessBuilder", Pattern.LITERAL),
            Pattern.compile("coroutine\\.yield", Pattern.LITERAL)
    };

    private static final Pattern BASE64_PATTERN = Pattern.compile("[A-Za-z0-9+/=]{30,}");
    private static final Pattern OBFUSCATION_PATTERN = Pattern.compile("[^a-zA-Z0-9_ \\n]{20,}");

    public static boolean isScriptSafe(String script) {
        for (var pattern : BLACKLISTED_PATTERNS) {
            if (pattern.matcher(script).find()) {
                logger.warn("Blocked script: Contains illegal function '{}'", pattern.pattern());
                return false;
            }
        }

        if (BASE64_PATTERN.matcher(script).find()) {
            logger.warn("Blocked script: Contains potential Base64 obfuscation");
            return false;
        }

        if (OBFUSCATION_PATTERN.matcher(script).find()) {
            logger.warn("Blocked script: Contains excessive special characters");
            return false;
        }

        return true;
    }
}