package tech.atani.client.module.impl.render;

import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.util.vector.Vector4f;
import tech.atani.client.event.impl.Render2DEvent;
import tech.atani.client.event.impl.Render3DEvent;
import tech.atani.client.module.Module;
import tech.atani.client.module.data.Category;
import tech.atani.client.module.data.ModuleData;
import tech.atani.client.setting.impl.ColorSetting;
import tech.atani.client.setting.impl.MultiSelectSetting;
import tech.atani.client.util.client.events.base.Listen;
import tech.atani.client.util.game.render.ProjectionUtil;
import tech.atani.client.util.game.render.shader.data.renderer.Renderer;

import java.awt.*;
import java.util.HashMap;
import java.util.Map;

@SuppressWarnings("unused")
@ModuleData(name = "ESP", category = Category.RENDER, description = "modules.esp.description")
public class ESP extends Module {

    private final Map<Entity, Vector4f> pos = new HashMap<>();

    private final ColorSetting boxColor = new ColorSetting.Builder()
            .name("modules.esp.boxcolor")
            .value(new Color(255, 255, 255))
            .build();

    private final ColorSetting healthColor = new ColorSetting.Builder()
            .name("modules.esp.healthcolor")
            .value(new Color(57, 162, 57))
            .build();

    private final MultiSelectSetting entityTypes = new MultiSelectSetting.Builder()
            .name("modules.esp.entitytypes")
            .values("Self", "Players", "Mobs", "Animals")
            .value("Players", "Mobs", "Animals")
            .build();

    private boolean entity(Entity entity) {
        return switch (entity) {
            case EntityPlayer player when entityTypes.isEnabled("Players") && entity != mc.thePlayer -> true;
            case EntityMob mob when entityTypes.isEnabled("Mobs") -> true;
            case EntityAnimal animal when entityTypes.isEnabled("Animals") -> true;
            default -> entity == mc.thePlayer && entityTypes.isEnabled("Self");
        };
    }

    @Listen
    public void onRender3D(Render3DEvent event) {
        pos.clear();
        for (final Entity entity : mc.theWorld.loadedEntityList) {
            if (entity(entity) && ProjectionUtil.isInView(entity)) {
                pos.put(entity, ProjectionUtil.getEntityPositionsOn2D(entity));
            }
        }
    }

    @Listen
    private void onRender2DEvent(Render2DEvent event) {
        for (Entity entity : pos.keySet()) {
            final Vector4f pos = this.pos.get(entity);
            final float x = pos.getX(), y = pos.getY(), width = pos.getZ() - x, height = pos.getW() - y;

            Renderer.drawRectangle(x - 4, y - 1, 2, height + 2, Color.BLACK);
            Renderer.drawRectangle(x - 3.5f, y - 0.5f, 1, height + 0.5f, healthColor.getValue());

            Renderer.drawRectangle(x - 1, y - 1, width + 2, height + 2, Color.BLACK, 0.8F);
            Renderer.drawRectangle(x, y, width, height, boxColor.getValue(), 0.8F);
            Renderer.drawRectangle(x + 1, y + 1, width - 2, height - 2, Color.BLACK, 0.8F);
        }
    }
}