package tech.atani.client.module.impl.render;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.util.MathHelper;
import tech.atani.client.Atani;
import tech.atani.client.event.impl.Render3DEvent;
import tech.atani.client.module.Module;
import tech.atani.client.module.data.Category;
import tech.atani.client.module.data.ModuleData;
import tech.atani.client.module.impl.combat.KillAura;
import tech.atani.client.util.client.events.base.Listen;
import tech.atani.client.util.game.player.RotationUtil;
import tech.atani.client.util.game.render.ColorUtil;
import tech.atani.client.util.system.math.MathUtil;

import java.awt.*;

import static org.lwjgl.opengl.GL11.*;

@SuppressWarnings("unused")
@ModuleData(name = "ChinaHat", category = Category.RENDER, description = "modules.chinahat.description")
public class ChinaHat extends Module {

    @Listen
    private void onEvent(Render3DEvent event) {
        if (mc.thePlayer == null || mc.theWorld == null || mc.gameSettings.thirdPersonView == 0 ||
                mc.thePlayer.isDead || mc.thePlayer.isInvisible()) return;

        float partialTicks = event.getTicks();
        double renderPosX = mc.getRenderManager().viewerPosX;
        double renderPosY = mc.getRenderManager().viewerPosY;
        double renderPosZ = mc.getRenderManager().viewerPosZ;

        glPushMatrix();
        glShadeModel(GL_SMOOTH);
        GlStateManager.enableBlend();
        GlStateManager.enableAlpha();
        GlStateManager.disableCull();
        GlStateManager.disableDepth();
        GlStateManager.disableLighting();
        GlStateManager.disableTexture2D();
        GlStateManager.color(1, 1, 1, 1);
        OpenGlHelper.glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA, GL_ONE, GL_ZERO);

        double posX = mc.thePlayer.lastTickPosX + (mc.thePlayer.posX - mc.thePlayer.lastTickPosX) * partialTicks - renderPosX;
        double posY = mc.thePlayer.lastTickPosY + (mc.thePlayer.posY - mc.thePlayer.lastTickPosY) * partialTicks - renderPosY;
        double posZ = mc.thePlayer.lastTickPosZ + (mc.thePlayer.posZ - mc.thePlayer.lastTickPosZ) * partialTicks - renderPosZ;

        double height = mc.thePlayer.getEntityBoundingBox().maxY - mc.thePlayer.getEntityBoundingBox().minY + 0.02;
        double radius = mc.thePlayer.getEntityBoundingBox().maxX - mc.thePlayer.getEntityBoundingBox().minX;

        float yaw = MathUtil.interpolate(mc.thePlayer.prevRotationYawHead, mc.thePlayer.rotationYawHead, partialTicks).floatValue();

        if (Atani.instance.moduleStorage.getT(KillAura.class).isEnabled()) {
            yaw = MathUtil.interpolate(mc.thePlayer.prevRotationYawHead,
                    mc.thePlayer.rotationYawHead, partialTicks).floatValue();
        }

        float pitch = MathUtil.interpolate(RotationUtil.getLastPitch(), RotationUtil.getPitch(), partialTicks).floatValue();

        glTranslated(0, posY + height, 0);
        glEnable(GL_LINE_SMOOTH);
        glHint(GL_LINE_SMOOTH_HINT, GL_NICEST);
        glRotated(yaw, 0, -1, 0);
        glRotated(pitch / 3.0, 1, 0, 0);
        glTranslated(0, 0, pitch / 270.0);
        glLineWidth(2);

        glBegin(GL_LINE_LOOP);
        for (int i = 0; i <= 180; i++) {
            int color1 = new Color(148, 226, 213).getRGB();
            ColorUtil.color(color1);
            glVertex3d(
                    posX - Math.sin(i * MathHelper.PI2 / 90) * radius,
                    -(mc.thePlayer.isSneaking() ? 0.2 : 0) - 0.002,
                    posZ + Math.cos(i * MathHelper.PI2 / 90) * radius
            );
        }
        glEnd();

        glBegin(GL_TRIANGLE_FAN);
        int color12 = new Color(243, 139, 168).getRGB();
        ColorUtil.color(color12);
        glVertex3d(posX, 0.3 - (mc.thePlayer.isSneaking() ? 0.23 : 0), posZ);
        for (int i = 0; i <= 180; i++) {
            int color1 = new Color(203, 166, 247).getRGB();
            ColorUtil.color(color1);
            glVertex3d(
                    posX - Math.sin(i * MathHelper.PI2 / 90) * radius,
                    -(mc.thePlayer.isSneaking() ? 0.23F : 0),
                    posZ + Math.cos(i * MathHelper.PI2 / 90) * radius
            );
        }
        glVertex3d(posX, 0.3 - (mc.thePlayer.isSneaking() ? 0.23 : 0), posZ);
        glEnd();

        glPopMatrix();
        ColorUtil.resetColor();
        GlStateManager.enableCull();
        GlStateManager.enableDepth();
        GlStateManager.enableTexture2D();
        GlStateManager.disableBlend();
        glDisable(GL_LINE_SMOOTH);
        glShadeModel(GL_FLAT);
    }
}