package tech.atani.client.module.impl.player;

import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import tech.atani.client.event.impl.UpdateEvent;
import tech.atani.client.module.Module;
import tech.atani.client.module.data.Category;
import tech.atani.client.module.data.ModuleData;
import tech.atani.client.setting.impl.CheckBoxSetting;
import tech.atani.client.setting.impl.SliderSetting;
import tech.atani.client.util.client.events.base.Listen;
import tech.atani.client.util.game.player.InventoryUtil;
import tech.atani.client.util.game.player.item.ItemTakeRecord;
import tech.atani.client.util.system.HWIDUtil;
import tech.atani.client.util.system.math.TimerUtil;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

@ModuleData(name = "Stealer", category = Category.PLAYER, description = "modules.stealer.description")
@SuppressWarnings("unused")
public class Stealer extends Module {

    private final SliderSetting delay = new SliderSetting.Builder()
            .name("modules.stealer.delay")
            .value(80)
            .min(0)
            .max(1000)
            .build();

    private final SliderSetting startingDelay = new SliderSetting.Builder()
            .name("modules.stealer.startdelay")
            .value(30)
            .min(0)
            .max(1000)
            .build();

    private final CheckBoxSetting closeAfterStealing = new CheckBoxSetting.Builder()
            .name("modules.stealer.finishclose")
            .value(false)
            .build();

    private final CheckBoxSetting titleCheck = new CheckBoxSetting.Builder()
            .name("modules.stealer.titlecheck")
            .value(false)
            .build();

    private final TimerUtil actionTimer = new TimerUtil();
    private final TimerUtil startTimer = new TimerUtil();

    private int lastStolenSlot = -1;
    private boolean randomizeFirstSlot = true;
    private long currentDelay = -1;

    private static final int RANDOM_VARIATION = 15;

    @Listen
    private void onEvent(UpdateEvent event) {
        if (!(mc.currentScreen instanceof GuiChest chestGui)) {
            reset();
            return;
        }

        if (!startTimer.hasTimeElapsed(startingDelay.getValue().longValue())) {
            return;
        }

        if (titleCheck.getValue() && !InventoryUtil.isValidChest(chestGui)) {
            return;
        }

        if (currentDelay == -1) {
            currentDelay = calculateRandomDelay();
        }

        if (!actionTimer.hasTimeElapsed(currentDelay)) {
            return;
        }

        ContainerChest containerChest;
        try {
            containerChest = (ContainerChest) chestGui.inventorySlots;
        } catch (ClassCastException e) {
            reset();
            return;
        }

        IInventory chestInventory = containerChest.getLowerChestInventory();
        handleChestStealing(containerChest, chestInventory);

        actionTimer.reset();
        currentDelay = calculateRandomDelay();
    }

    private long calculateRandomDelay() {
        long baseDelay = delay.getValue().longValue();
        long variation = (long) (HWIDUtil.random.nextDouble() * RANDOM_VARIATION) - (RANDOM_VARIATION / 2);
        return Math.max(0, baseDelay + variation);
    }

    private void handleChestStealing(ContainerChest containerChest, IInventory chestInventory) {
        List<ItemTakeRecord> slots = new ArrayList<>();
        for (int slot : InventoryUtil.getNonEmptySlots(chestInventory)) {
            slots.add(new ItemTakeRecord(slot, distance(slot, lastStolenSlot)));
        }

        if (slots.isEmpty() || InventoryUtil.isInventoryFull()) {
            handleCompletion();
            return;
        }

        if (randomizeFirstSlot) {
            lastStolenSlot = slots.get(HWIDUtil.random.nextInt(slots.size())).slot();
            randomizeFirstSlot = false;
        } else {
            slots.sort(Comparator.comparingInt(ItemTakeRecord::distance));
            lastStolenSlot = slots.getFirst().slot();
        }

        InventoryUtil.stealSlot(lastStolenSlot);
    }

    private void handleCompletion() {
        if (closeAfterStealing.getValue()) {
            mc.thePlayer.closeScreen();
        }
        reset();
    }

    private int distance(int slot1, int slot2) {
        if (slot2 == -1) return Integer.MAX_VALUE;
        int row1 = slot1 / 9, col1 = slot1 % 9;
        int row2 = slot2 / 9, col2 = slot2 % 9;
        return Math.abs(row1 - row2) + Math.abs(col1 - col2);
    }

    private void reset() {
        startTimer.reset();
        actionTimer.reset();
        lastStolenSlot = -1;
        randomizeFirstSlot = true;
        currentDelay = -1;
    }

    @Override
    public void onDisable() {
        reset();
    }
}