package tech.atani.client.module.impl.player;

import net.minecraft.block.*;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import org.lwjgl.util.vector.Vector2f;
import tech.atani.client.event.data.State;
import tech.atani.client.event.impl.*;
import tech.atani.client.module.Module;
import tech.atani.client.module.data.Category;
import tech.atani.client.module.data.ModuleData;
import tech.atani.client.setting.impl.CheckBoxSetting;
import tech.atani.client.setting.impl.SliderSetting;
import tech.atani.client.setting.impl.StringSetting;
import tech.atani.client.util.client.events.base.Listen;
import tech.atani.client.util.client.events.base.Priority;
import tech.atani.client.util.game.entity.RayCastUtil;
import tech.atani.client.util.game.player.*;
import tech.atani.client.util.game.player.world.BlockCache;
import tech.atani.client.util.system.math.TimerUtil;

@SuppressWarnings("unused")
@ModuleData(name = "Scaffold", description = "modules.scaffold.description", category = Category.PLAYER)
public class Scaffold extends Module {
    private final StringSetting itemSwitchMode = new StringSetting.Builder()
                    .name("modules.scaffold.itemswitchmode")
                    .value("Switch")
                    .values("Switch", "None")
                    .build(),

    towerMode = new StringSetting.Builder()
                    .name("modules.scaffold.towermode")
                    .value("Jump")
                    .values("Jump", "Motion", "Vulcan")
                    .build(),

    sprintMode = new StringSetting.Builder()
                    .name("modules.scaffold.sprintmode")
                    .value("None")
                    .values("None", "Always")
                    .build();

    private final CheckBoxSetting keepY = new CheckBoxSetting.Builder()
            .name("modules.scaffold.keepy")
            .value(false)
            .build();

    private final CheckBoxSetting sneak = new CheckBoxSetting.Builder()
            .name("modules.scaffold.sneak")
            .value(false)
            .build();

    private final StringSetting sneakMode = new StringSetting.Builder()
            .name("modules.scaffold.sneakmode")
            .value("Eagle")
            .values("Eagle", "Blatant", "Always")
            .build()
            .hide(() -> !sneak.getValue());

    private final SliderSetting sneakDelay = new SliderSetting.Builder()
                    .name("modules.scaffold.sneakdelay")
                    .value(57)
                    .min(0)
                    .max(300)
                    .build()
                    .hide(() -> !sneak.getValue() || !(sneakMode.getValue().equals("Eagle") || sneakMode.getValue().equals("Blatant"))),

    unSneakDelay = new SliderSetting.Builder()
                    .name("modules.scaffold.unsneakdelay")
                    .value(299)
                    .min(0)
                    .max(300)
                    .build()
                    .hide(() -> !sneak.getValue() || !(sneakMode.getValue().equals("Eagle") || sneakMode.getValue().equals("Blatant")));

    private final StringSetting rotationMode = new StringSetting.Builder()
            .name("modules.scaffold.rotmode")
            .value("Raycast")
            .values("Raycast", "Godbridge", "Watchdog")
            .build();

    public Scaffold() {
        keepY.hide(() -> rotationMode.is("Raycast"));
    }

    private final DistanceCounter distCounter = new DistanceCounter();
    private final TimerUtil unSneakCounter = new TimerUtil(), sneakCounter = new TimerUtil();
    private float targetYaw, targetPitch;
    private BlockCache cache, lastBlockCache;
    private boolean wasSneaking;
    private double posY;

    @Listen(priority = Priority.HIGHEST)
    private void onRunTick(GameLoopEvent event) {
        if (mc.thePlayer == null || mc.theWorld == null) return;

        cache = BlockCache.getBlockInfo();

        if (!rotationMode.is("Raytrace") && keepY.getValue()) {
            if (mc.thePlayer.posY < posY || (!mc.thePlayer.onGround && !MovementUtil.isMoving()) || mc.thePlayer.posY - posY > 6 || !keepY.getValue()) {
                posY = mc.thePlayer.posY - 0.9;
            }

            BlockPos playerBlockPos = new BlockPos(mc.thePlayer.posX, posY, mc.thePlayer.posZ);
            cache = BlockCache.getBlockInfo(playerBlockPos);
        }

        if (cache == null) {
            cache = lastBlockCache;
        } else {
            lastBlockCache = cache;
        }
    }

    @Listen
    private void onMotion(MotionEvent event) {
        if (mc.thePlayer == null || cache == null) return;
        if (event.state.equals(State.PRE)) {

            switch (sprintMode.getValue()) {
                case "None" -> {
                    // not needed, this is handled in Sprint
                }
                case "Always" -> mc.thePlayer.setSprinting(MovementUtil.isMoving());
            }

            ItemStack heldItem = mc.thePlayer.getHeldItem();
            if (heldItem == null || !(heldItem.getItem() instanceof ItemBlock)) {
                if (itemSwitchMode.getValue().equals("Switch")) {
                    int slot = InventoryUtil.findBlockSlot();
                    if (slot != -1) InventoryUtil.setSlot(slot);
                }
            }

            if (!MovementUtil.isMoving() && mc.gameSettings.keyBindJump.isKeyDown() && (towerMode.is("Motion") || towerMode.is("Vulcan"))) {
                if (towerMode.is("Motion"))
                    mc.thePlayer.motionY = 0.42;

                if (mc.thePlayer.onGround) {
                    mc.thePlayer.jump();

                    if (towerMode.is("Vulcan"))
                        mc.thePlayer.motionY = 0.6;
                }
            }

            if (sneak.getValue()) {
                switch (sneakMode.getValue()) {
                    case "Eagle":
                        boolean shouldSneak = mc.theWorld.getBlockState(new BlockPos(mc.thePlayer.posX, mc.thePlayer.posY - 1.0, mc.thePlayer.posZ)).getBlock() instanceof BlockAir && mc.thePlayer.onGround;
                        if (shouldSneak && sneakCounter.hasTimeElapsed(sneakDelay.getValue().longValue(), true)) {
                            mc.gameSettings.keyBindSneak.pressed = true;
                            wasSneaking = true;
                        } else if (!shouldSneak && wasSneaking && unSneakCounter.hasTimeElapsed(unSneakDelay.getValue().longValue(), true)) {
                            mc.gameSettings.keyBindSneak.pressed = false;
                            wasSneaking = false;
                        }
                        break;
                    case "Always":
                        mc.gameSettings.keyBindSneak.pressed = true;
                        break;
                }
            }

            if (sneak.getValue() && sneakMode.getValue().equals("Blatant")) {
                if (unSneakCounter.hasTimeElapsed(unSneakDelay.getValue().longValue(), true)) {
                    mc.gameSettings.keyBindSneak.pressed = false;
                }
                distCounter.tick(mc.thePlayer);
                if (distCounter.getTravelled() >= 1 && sneakCounter.hasTimeElapsed(sneakDelay.getValue().longValue(), true)) {
                    mc.gameSettings.keyBindSneak.pressed = true;
                    distCounter.reset();
                }
            }
        }
    }

    @Listen
    private void onProcess(ClickProcessingEvent event) {
        if (mc.thePlayer == null || cache == null) return;

        ItemStack heldItem = mc.thePlayer.getHeldItem();
        if (heldItem != null && heldItem.getItem() instanceof net.minecraft.item.ItemBlock && cache.getPosition() != null) {

            if (rotationMode.is("Raycast")) {
                MovingObjectPosition ray = RayCastUtil.rayCast(new Vector2f(targetYaw, targetPitch), mc.playerController.getBlockReachDistance(), 1.0f, mc.thePlayer);
                if (ray != null && ray.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK && mc.playerController.onPlayerRightClick(mc.thePlayer, mc.theWorld, mc.thePlayer.getHeldItem(), ray.getBlockPos(), ray.sideHit, ray.hitVec)) {
                    cache.sendConditionalSwing(ray);
                }
            }

            if (rotationMode.is("Watchdog") || rotationMode.is("Godbridge")) {
                Vec3 hitVec = new Vec3(cache.getPosition()).addVector(0.5, 0.5, 0.5);
                if (mc.playerController.onPlayerRightClick(mc.thePlayer, mc.theWorld, heldItem, cache.getPosition(), cache.getFacing(), hitVec)) {
                    mc.thePlayer.swingItem();
                }
            }
        }
    }

    @Listen(priority = Priority.HIGHEST)
    private void onRots(RotationEvent event) {
        if (cache == null) return;

        boolean rotComplete = false;
        int ticks = 0;

        if (MovementUtil.isMoving()) {
            targetYaw = (float) Math.toDegrees(MovementUtil.getDirectionKeybinds(mc.thePlayer.rotationYaw - 180.0F));
        }

        switch (rotationMode.getValue()) {
            case "Raycast" -> {
                if (cache.getPosition() != null && cache.getFacing() != null) {

                    float[] rots = RotationUtil.getDirectionToBlock(cache.getPosition().getX(), cache.getPosition().getY(), cache.getPosition().getZ(), cache.getFacing());

                    Vector2f rotationVector = new Vector2f(targetYaw, targetPitch);

                    MovingObjectPosition rotationRay = RayCastUtil.rayCast(rotationVector, mc.playerController.getBlockReachDistance(), 1.0F, mc.thePlayer);

                    targetPitch = RotationUtil.calculatePitch(cache.getPosition(), cache.getFacing(), targetYaw, targetPitch, 84);
                    if (rotationRay != null && rotationRay.getBlockPos() != null && !rotationRay.getBlockPos().equalsBlockPos(cache.getPosition())) {

                        for (int maxTicksx = (int)Math.abs(MathHelper.wrapAngleTo180_float(targetYaw - rots[0]) / 4.0F);
                             ticks <= maxTicksx && !rotComplete;
                             ticks++
                        ) {
                            targetPitch = RotationUtil.calculatePitch(cache.getPosition(), cache.getFacing(), targetYaw, targetPitch, 84);
                            MovingObjectPosition stopRay = RayCastUtil.rayCast(rotationVector, mc.playerController.getBlockReachDistance(), 1.0F, mc.thePlayer);

                            if (stopRay != null && stopRay.getBlockPos() != null && stopRay.getBlockPos().equalsBlockPos(cache.getPosition()) && stopRay.sideHit == cache.getFacing()) {
                                rotComplete = true;
                            }
                        }
                    }

                    event.setYaw(targetYaw);
                    event.setPitch(targetPitch);
                }
            }
            case "Godbridge" -> {
                float backwardsYaw = (float) Math.toDegrees(MovementUtil.getDirectionKeybinds(mc.thePlayer.rotationYaw - 180.0F));
                float endYaw = backwardsYaw + 45;
                float endPitch = mc.thePlayer.movementInput.jump || mc.gameSettings.keyBindJump.isKeyDown() ? 85 : 84;

                targetYaw = endYaw;
                targetPitch = endPitch;
            }
            case "Watchdog" -> {
                float backwardsYaw = (float) Math.toDegrees(MovementUtil.getDirectionKeybinds(mc.thePlayer.rotationYaw - 180.0F));
                float endYaw = (mc.thePlayer.onGround && mc.gameSettings.keyBindJump.isKeyDown()) || (!mc.thePlayer.onGround && mc.gameSettings.keyBindJump.isKeyDown() && mc.thePlayer.fallDistance < 0.1F)
                        ? mc.thePlayer.rotationYaw
                        : backwardsYaw + 45;
                float endPitch = mc.thePlayer.movementInput.jump || mc.gameSettings.keyBindJump.isKeyDown() ? 85 : 84;

                targetYaw = endYaw;
                targetPitch = endPitch;
            }
        }

        event.setYaw(targetYaw);
        event.setPitch(targetPitch);
    }

    @Override
    public void onDisable() {
        distCounter.reset();
        unSneakCounter.reset();
        sneakCounter.reset();
        cache = null;
        mc.thePlayer.setSprinting(false);
    }

    @Override
    public void onEnable() {
        targetPitch = 79f;
        wasSneaking = false;
    }

    @Override
    public String getSuffix() {
        return rotationMode.stringValue();
    }
}