package tech.atani.client.module.impl.player;

import net.minecraft.block.Block;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.item.*;
import tech.atani.client.event.impl.UpdateEvent;
import tech.atani.client.module.Module;
import tech.atani.client.module.data.Category;
import tech.atani.client.module.data.ModuleData;
import tech.atani.client.setting.impl.CheckBoxSetting;
import tech.atani.client.setting.impl.SliderSetting;
import tech.atani.client.util.client.events.base.Listen;
import tech.atani.client.util.game.player.InventoryUtil;
import tech.atani.client.util.system.math.MathUtil;
import tech.atani.client.util.system.math.TimerUtil;
import java.util.*;
import java.util.function.Consumer;

@ModuleData(name = "Manager", category = Category.PLAYER, description = "modules.manager.description")
@SuppressWarnings("unused")
public class Manager extends Module {
    private final SliderSetting startDelay = new SliderSetting.Builder()
            .name("modules.manager.startdelay")
            .value(80)
            .min(0)
            .max(1000)
            .build();

    private final SliderSetting minDelay = new SliderSetting.Builder()
            .name("modules.manager.mindelay")
            .value(80)
            .min(0)
            .max(1000)
            .build();

    private final SliderSetting maxDelay = new SliderSetting.Builder()
            .name("modules.manager.maxdelay")
            .value(120)
            .min(0)
            .max(1000)
            .build();

    private final CheckBoxSetting inventoryOnly = new CheckBoxSetting.Builder()
            .name("modules.manager.inventory")
            .value(true)
            .build();

    private final CheckBoxSetting keepSword = new CheckBoxSetting.Builder()
            .name("modules.manager.keepsword")
            .value(true)
            .build();

    private final CheckBoxSetting keepPickaxe = new CheckBoxSetting.Builder()
            .name("modules.manager.keeppickaxe")
            .value(true)
            .build();

    private final CheckBoxSetting keepAxe = new CheckBoxSetting.Builder()
            .name("modules.manager.keepaxe")
            .value(true)
            .build();

    private final CheckBoxSetting keepShovel = new CheckBoxSetting.Builder()
            .name("modules.manager.keepshovel")
            .value(false)
            .build();

    private final CheckBoxSetting keepFood = new CheckBoxSetting.Builder()
            .name("modules.manager.keepfood")
            .value(true)
            .build();

    private final TimerUtil actionTimer = new TimerUtil();
    private final TimerUtil startTimer = new TimerUtil();

    @Override
    public void onEnable() {
        actionTimer.reset();
    }

    @Override
    public void onDisable() {
        actionTimer.reset();
    }

    @Listen
    private void onEvent(UpdateEvent event) {
        if (mc.currentScreen instanceof GuiInventory || !inventoryOnly.getValue()) {
            manageInventory();
        }
    }

    private void manageInventory() {
        List<Integer> throwableItems = new ArrayList<>();
        Set<Integer> processedSlots = new HashSet<>();
        int[] bestItems = getBestItems();

        Map<Class<? extends Item>, Consumer<Integer>> itemHandlers = createItemHandlers(throwableItems, bestItems);

        for (int i = 0; i < 40; i++) {
            ItemStack stack = mc.thePlayer.inventory.getStackInSlot(i);
            if (stack == null || processedSlots.contains(i)) continue;

            itemHandlers.getOrDefault(stack.getItem().getClass(), this::handleTrash).accept(i);
            processedSlots.add(i);
        }

        handleArmor(bestItems);
        handleHotbarItems(bestItems);
    }

    private int[] getBestItems() {
        return new int[]{
                InventoryUtil.getBestArmor(0),
                InventoryUtil.getBestArmor(1),
                InventoryUtil.getBestArmor(2),
                InventoryUtil.getBestArmor(3),
                InventoryUtil.getBestSword(false),
                InventoryUtil.getBestPickaxe(),
                InventoryUtil.getBestAxe(),
                InventoryUtil.getBestShovel(),
                InventoryUtil.getBestBlock(),
                InventoryUtil.getBestFood()
        };
    }

    private Map<Class<? extends Item>, Consumer<Integer>> createItemHandlers(List<Integer> throwableItems, int[] bestItems) {
        Map<Class<? extends Item>, Consumer<Integer>> itemHandlers = new HashMap<>();
        itemHandlers.put(ItemBlock.class, i -> handleBlockItem(i, bestItems[8]));
        itemHandlers.put(ItemSnowball.class, i -> handleThrowableItem(i, throwableItems));
        itemHandlers.put(ItemEgg.class, i -> handleThrowableItem(i, throwableItems));
        itemHandlers.put(ItemSword.class, i -> handleBestItem(i, bestItems[4]));
        itemHandlers.put(ItemFood.class, i -> handleBestItem(i, bestItems[9]));
        itemHandlers.put(ItemPickaxe.class, i -> handleBestItem(i, bestItems[5]));
        itemHandlers.put(ItemAxe.class, i -> handleBestItem(i, bestItems[6]));
        itemHandlers.put(ItemSpade.class, i -> handleBestItem(i, bestItems[7]));
        return itemHandlers;
    }

    private void handleBlockItem(int i, int bestBlock) {
        Block block = ((ItemBlock) mc.thePlayer.inventory.getStackInSlot(i).getItem()).getBlock();
        if (!InventoryUtil.canPlaceOnBlock(block)) {
            dropItem(i);
        } else if (i != bestBlock && bestBlock != -1) {
            dropItem(i);
        }
    }

    private void handleThrowableItem(int i, List<Integer> throwableItems) {
        throwableItems.add(i);
        if (throwableItems.size() > 4) {
            dropItem(throwableItems.getLast());
        }
    }

    private void handleBestItem(int i, int bestItem) {
        if (bestItem != -1 && bestItem != i) {
            dropItem(i);
        }
    }

    private void handleTrash(int i) {
        if (InventoryUtil.isTrash(mc.thePlayer.inventory.getStackInSlot(i).getItem())) {
            dropItem(i);
        }
    }

    private void handleArmor(int[] bestItems) {
        for (int i = 0; i < 40; i++) {
            ItemStack stack = mc.thePlayer.inventory.getStackInSlot(i);
            if (stack == null) continue;
            if (stack.getItem() instanceof ItemArmor armor) {
                switch (armor.armorType) {
                    case 0 -> { if (i != bestItems[0]) dropItem(i); }
                    case 1 -> { if (i != bestItems[1]) dropItem(i); }
                    case 2 -> { if (i != bestItems[2]) dropItem(i); }
                    case 3 -> { if (i != bestItems[3]) dropItem(i); }
                }
            }
        }
        equipArmor(bestItems);
    }

    private void equipArmor(int[] bestItems) {
        if (bestItems[0] != -1 && bestItems[0] != 39) shiftClickItem(bestItems[0]);
        if (bestItems[1] != -1 && bestItems[1] != 38) shiftClickItem(bestItems[1]);
        if (bestItems[2] != -1 && bestItems[2] != 37) shiftClickItem(bestItems[2]);
        if (bestItems[3] != -1 && bestItems[3] != 36) shiftClickItem(bestItems[3]);
    }

    private void handleHotbarItems(int[] bestItems) {
        Map<CheckBoxSetting, Integer> hotbarItems = Map.of(
                keepSword, bestItems[4],
                keepPickaxe, bestItems[5],
                keepAxe, bestItems[6],
                keepShovel, bestItems[7],
                keepFood, bestItems[9]
        );
        Map<CheckBoxSetting, Integer> hotbarSlots = Map.of(
                keepSword, 1,
                keepPickaxe, 2,
                keepAxe, 3,
                keepShovel, 4,
                keepFood, 5
        );
        hotbarItems.forEach((setting, bestItem) -> {
            if (setting.getValue() && bestItem != -1 && bestItem != hotbarSlots.get(setting) - 1) {
                swapItem(bestItem, hotbarSlots.get(setting) - 1);
            }
        });
        if (bestItems[8] != -1 && bestItems[8] != 8) {
            swapItem(bestItems[8], 8);
        }
    }

    private void dropItem(int slot) {
        if (!actionTimer.hasTimeElapsed((long) MathUtil.range(minDelay.getValue(), maxDelay.getValue())) || !startTimer.hasTimeElapsed(startDelay.getValue().longValue())) {
            return;
        }
        mc.playerController.windowClick(mc.thePlayer.inventoryContainer.windowId, correctSlot(slot), 1, 4, mc.thePlayer);
        actionTimer.reset();
    }

    private void swapItem(int slot, int targetSlot) {
        if (!actionTimer.hasTimeElapsed((long) MathUtil.range(minDelay.getValue(), maxDelay.getValue())) || !startTimer.hasTimeElapsed(startDelay.getValue().longValue())) {
            return;
        }
        mc.playerController.windowClick(0, correctSlot(slot), targetSlot, 2, mc.thePlayer);
        actionTimer.reset();
    }

    private void shiftClickItem(int item) {
        if (!actionTimer.hasTimeElapsed((long) MathUtil.range(minDelay.getValue(), maxDelay.getValue())) || !startTimer.hasTimeElapsed(startDelay.getValue().longValue())) {
            return;
        }
        mc.playerController.windowClick(mc.thePlayer.inventoryContainer.windowId, correctSlot(item), 0, 1, mc.thePlayer);
        actionTimer.reset();
    }

    private int correctSlot(int slot) {
        if (slot >= 36) return 8 - (slot - 36);
        if (slot < 9) return slot + 36;
        return slot;
    }
}