package tech.atani.client.module.impl.player;

import tech.atani.client.event.impl.HitEvent;
import tech.atani.client.module.Module;
import tech.atani.client.module.data.Category;
import tech.atani.client.module.data.ModuleData;
import tech.atani.client.util.client.events.base.Listen;
import tech.atani.client.util.system.math.TimerUtil;

@ModuleData(name = "HitSound", category = Category.PLAYER, description = "Plays a sound when you hit an entity")
public class HitSound extends Module {
    private final TimerUtil soundCooldown = new TimerUtil();

    @Override
    public void onEnable() {
        soundCooldown.reset();
    }

    @Override
    public void onDisable() {
        soundCooldown.reset();
    }

    @Listen
    private void onHit(HitEvent event) {
        if (mc.thePlayer == null || mc.theWorld == null) {
            return;
        }

        if (soundCooldown.hasTimeElapsed(300)) {
            playHitSound();
            soundCooldown.reset();
        }
    }

    private void playHitSound() {
        mc.getSoundHandler().playSoundFromFullPath("/assets/atani/sounds/neverloose.ogg", 1.0F, 1.0F);
    }
}