package tech.atani.client.module.impl.player;

import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C13PacketPlayerAbilities;
import tech.atani.client.event.impl.PacketEvent;
import tech.atani.client.module.Module;
import tech.atani.client.module.data.Category;
import tech.atani.client.module.data.ModuleData;
import tech.atani.client.setting.impl.CheckBoxSetting;
import tech.atani.client.util.client.events.base.Listen;

@ModuleData(
        name = "Disabler",
        category = Category.PLAYER,
        description = "modules.disabler.description" //"Does packet magic to disable anticheats"
)
public class Disabler extends Module {

    private final CheckBoxSetting cancelC13 = new CheckBoxSetting.Builder()
            .name("modules.disabler.cancel.c13")
            .value(false)
            .build();

    @Listen
    public void onPacketSend(PacketEvent event)
    {
        Packet<?> packet = event.getPacket();

        if (packet instanceof C13PacketPlayerAbilities && cancelC13.boolValue())
        {
            event.setCancelled(true);
        }
    }

}
