package tech.atani.client.module.impl.player;

import net.minecraft.block.Block;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MovingObjectPosition;
import tech.atani.client.event.impl.UpdateEvent;
import tech.atani.client.module.Module;
import tech.atani.client.module.data.Category;
import tech.atani.client.module.data.ModuleData;
import tech.atani.client.setting.impl.SliderSetting;
import tech.atani.client.util.client.events.base.Listen;
import tech.atani.client.util.game.player.InventoryUtil;
import tech.atani.client.util.system.math.TimerUtil;

@ModuleData(name = "AutoTool", category = Category.PLAYER, description = "modules.autotool.description")
@SuppressWarnings("unused")
public class AutoTool extends Module {

    private final SliderSetting delay = new SliderSetting.Builder()
            .name("modules.autotool.delay")
            .value(10)
            .min(0)
            .max(100)
            .build();

    private final TimerUtil actionTimer = new TimerUtil();
    private int originalSlot = -1;
    private boolean switched = false;

    @Override
    public void onEnable() {
        actionTimer.reset();
        originalSlot = -1;
        switched = false;
    }

    @Override
    public void onDisable() {
        actionTimer.reset();
        originalSlot = -1;
        switched = false;
    }

    @Listen
    private void onEvent(UpdateEvent event) {
        boolean isMining = mc.gameSettings.keyBindAttack.isKeyDown() && mc.objectMouseOver != null && mc.objectMouseOver.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK;

        if (isMining) {
            if (actionTimer.hasTimeElapsed(delay.getValue().longValue())) {
                BlockPos blockPos = mc.objectMouseOver.getBlockPos();
                Block block = mc.theWorld.getBlockState(blockPos).getBlock();

                int bestToolSlot = InventoryUtil.getBestToolAgainstBlock(block, true);

                if (bestToolSlot != -1 && bestToolSlot != mc.thePlayer.inventory.currentItem) {
                    if (originalSlot == -1) {
                        originalSlot = mc.thePlayer.inventory.currentItem;
                    }
                    mc.thePlayer.inventory.currentItem = bestToolSlot;
                    switched = true;
                    actionTimer.reset();
                }
            }
        } else {
            if (switched && originalSlot != -1) {
                mc.thePlayer.inventory.currentItem = originalSlot;
                originalSlot = -1;
                switched = false;
                actionTimer.reset();
            }
        }
    }
}