package tech.atani.client.module.impl.movement;

import lombok.Getter;
import lombok.RequiredArgsConstructor;
import tech.atani.client.module.Module;
import tech.atani.client.module.data.Category;
import tech.atani.client.module.data.ModuleData;
import tech.atani.client.module.impl.movement.speeds.LegitSpeed;
import tech.atani.client.module.impl.movement.speeds.NCPSpeed;
import tech.atani.client.module.sub.SubModule;
import tech.atani.client.setting.impl.StringSetting;
import tech.atani.client.util.client.interfaces.INameable;

@ModuleData(name = "Speed", description = "modules.speed.description", category = Category.MOVEMENT)
@SuppressWarnings("unused")
public class Speed extends Module {

    private final StringSetting mode = new StringSetting.Builder()
            .name("modules.speed.mode")
            .value("Legit")
            .values("NCP", "Legit")
            .build();

    private SpeedMode currentMode;

    @RequiredArgsConstructor
    enum SpeedMode implements INameable {
        NCP("NCP", new NCPSpeed()),
        LEGIT("Legit", new LegitSpeed());

        @Getter private final String name;
        private final SubModule component;

        public void onEnable() {
            component.onEnable();
        }

        public void onDisable() {
            component.onDisable();
        }

        public static SpeedMode fromName(String name) {
            for (SpeedMode mode : values()) {
                if (mode.getName().equalsIgnoreCase(name)) {
                    return mode;
                }
            }
            return LEGIT;
        }
    }

    @Override
    public void onEnable() {
        this.currentMode = SpeedMode.fromName(mode.stringValue());
        this.currentMode.onEnable();
    }

    @Override
    public void onDisable() {
        if (this.currentMode != null) {
            this.currentMode.onDisable();
        }
    }

    @Override
    public String getSuffix() {
        return mode.getValue();
    }
}
