package tech.atani.client.module.impl.movement;

import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import tech.atani.client.event.impl.MotionEvent;
import tech.atani.client.event.impl.SlowdownEvent;
import tech.atani.client.module.Module;
import tech.atani.client.module.data.Category;
import tech.atani.client.module.data.ModuleData;
import tech.atani.client.setting.impl.StringSetting;
import tech.atani.client.util.client.events.base.Listen;
import tech.atani.client.util.game.player.MovementUtil;

@ModuleData(
        name = "NoSlowdown",
        description = "Slow down, but no?",
        category = Category.MOVEMENT
)
public class NoSlowdown extends Module {

    private final StringSetting mode = new StringSetting.Builder()
            .name("Mode") // nice translation btw
            .value("Vanilla")
            .values("Vanilla", "Polar")
            .build();

    private int polarTickCounter = 0;

    @Override
    public void onDisable() {
        polarTickCounter = 0;
    }

    @Override
    public String getSuffix() {
        return mode.getValue();
    }

    @Listen
    private void onSlow(SlowdownEvent event) {
        ItemStack currentItem = mc.thePlayer.getCurrentEquippedItem();

        if (currentItem == null || !mc.thePlayer.isUsingItem() || !MovementUtil.isMoving()) {
            return;
        }

        if (currentItem.getItem() instanceof ItemSword) {
            event.setForward(1.0f);
            event.setStrafe(1.0f);
        }
    }

    @Listen
    private void onMotion(MotionEvent event) {
        ItemStack currentItem = mc.thePlayer.getCurrentEquippedItem();

        if (currentItem == null || !mc.thePlayer.isUsingItem() || !MovementUtil.isMoving()) {
            return;
        }

        switch (mode.getValue()) {
            case "Polar" -> {
                polarTickCounter++;
                if (polarTickCounter >= 20) {
                    mc.thePlayer.stopUsingItem();
                    mc.thePlayer.setItemInUse(currentItem, currentItem.getMaxItemUseDuration());
                    polarTickCounter = 0;
                }
            }
        }
    }
}