package tech.atani.client.module.impl.movement;

import tech.atani.client.event.impl.JumpEvent;
import tech.atani.client.event.impl.MoveFlyingEvent;
import tech.atani.client.event.impl.MoveInputEvent;
import tech.atani.client.module.Module;
import tech.atani.client.module.data.Category;
import tech.atani.client.module.data.ModuleData;
import tech.atani.client.setting.impl.CheckBoxSetting;
import tech.atani.client.util.client.events.base.Listen;
import tech.atani.client.util.game.player.MovementUtil;
import tech.atani.client.util.game.player.RotationUtil;

@ModuleData(name = "CorrectMovement", category = Category.MOVEMENT, description = "modules.correctmovement.description")
@SuppressWarnings("unused")
public class MovementCorrection extends Module {
    private final CheckBoxSetting silent = new CheckBoxSetting.Builder()
            .name("modules.correctmovement.silent")
            .value(true)
            .build();

    @Listen
    private void onMoveInput(MoveInputEvent event) {
        if (silent.boolValue()) {
            MovementUtil.correctMovement(event, RotationUtil.getYaw());
        }
    }

    @Listen
    private void onStrafe(MoveFlyingEvent event) {
        event.setYaw(RotationUtil.getYaw());
    }

    @Listen
    private void onJump(JumpEvent event) {
        event.setYaw(RotationUtil.getYaw());
    }
}
