package tech.atani.client.module.impl.movement;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

import tech.atani.client.module.Module;
import tech.atani.client.module.data.Category;
import tech.atani.client.module.data.ModuleData;
import tech.atani.client.module.impl.movement.flys.MotionFly;
import tech.atani.client.module.impl.movement.flys.CreativeFly;
import tech.atani.client.module.sub.SubModule;
import tech.atani.client.setting.impl.StringSetting;
import tech.atani.client.util.client.interfaces.INameable;

@ModuleData(name = "Fly", category = Category.MOVEMENT, description = "modules.fly.description")
@SuppressWarnings("unused")
public class Fly extends Module {

    private final StringSetting mode = new StringSetting.Builder()
            .name("modules.fly.mode")
            .value("Vanilla")
            .values("Vanilla", "Motion", "Ticocraft")
            .build();

    private FlyMode currentMode;

    @RequiredArgsConstructor
    enum FlyMode implements INameable {
        VANILLA("Vanilla", new CreativeFly()),
        MOTION("Motion", new MotionFly()),
        TICOCRAFT("Ticocraft", new MotionFly());

        @Getter private final String name;
        private final SubModule component;

        public void onEnable() {
            component.onEnable();
        }

        public void onDisable() {
            component.onDisable();
        }

        public static FlyMode fromName(String name) {
            for (FlyMode mode : values()) {
                if (mode.getName().equalsIgnoreCase(name)) {
                    return mode;
                }
            }
            return VANILLA;
        }
    }

    @Override
    public String getSuffix() {
        return mode.getValue();
    }

    @Override
    public void onEnable() {
        this.currentMode = FlyMode.fromName(mode.stringValue());
        this.currentMode.onEnable();
    }

    @Override
    public void onDisable() {
        if (this.currentMode != null) {
            this.currentMode.onDisable();
        }
    }
}