package tech.atani.client.module.impl.movement;

import tech.atani.client.event.data.State;
import tech.atani.client.event.impl.MovementEvent;
import tech.atani.client.event.impl.UpdateEvent;
import tech.atani.client.module.Module;
import tech.atani.client.module.data.Category;
import tech.atani.client.module.data.ModuleData;
import tech.atani.client.setting.impl.CheckBoxSetting;
import tech.atani.client.setting.impl.StringSetting;
import tech.atani.client.util.client.events.base.Listen;

/**
 * Customizable speed hell yeah
 * @author marie
 */
@ModuleData(
        name = "CustomSpeed",
        category = Category.MOVEMENT,
        description = "modules.customspeed.description"
)
public class CustomSpeed extends Module {

    /**
     * If we should jump
     */
    public final CheckBoxSetting jump = new CheckBoxSetting.Builder()
            .name("modules.customspeed.jump")
            .value(false)
            .build();

    /**
     * The method we use to jump (?)
     */
    public final StringSetting jumpMode = new StringSetting.Builder()
            .name("modules.customspeed.jump.mode")
            .values(
                    "Legit",  // Press jump keybind
                    "Legit2", // Press jump keybind when onground
                    "Vanilla" // mc.thePlayer.jump()
            )
            .value("Legit")
            .build()
            .hide(() -> !jump.boolValue());

    @Listen
    public void onUpdate(UpdateEvent event)
    {
        if (event.state != State.PRE) return;

        if (jump.boolValue())
        {
            switch (jumpMode.stringValue())
            {
                case "Legit":
                    mc.gameSettings.keyBindJump.pressed = true;
                    break;

                case "Legit2":
                    mc.gameSettings.keyBindJump.pressed = mc.thePlayer.onGround;
                    break;

                case "Vanilla":
                    if (mc.thePlayer.onGround)
                    {
                        mc.thePlayer.jump();
                    }
                    break;
            }
        }
    }

}
