package tech.atani.client.module.impl.hud;

import tech.atani.client.Atani;
import tech.atani.client.event.impl.OffsetRender2DEvent;
import tech.atani.client.module.data.Category;
import tech.atani.client.module.Module;
import tech.atani.client.module.data.ModuleData;
import tech.atani.client.screen.Icon;
import tech.atani.client.setting.impl.StringSetting;
import tech.atani.client.util.client.events.base.Listen;
import tech.atani.client.util.client.events.base.Priority;
import tech.atani.client.util.game.player.MovementUtil;
import tech.atani.client.util.game.render.catppuccin.Mocha;
import tech.atani.client.util.game.render.font.gui.font.renderer.SimpleFontRenderer;
import tech.atani.client.util.game.render.shader.data.renderer.Renderer;
import tech.atani.client.util.system.math.MathUtil;

import java.awt.*;

@SuppressWarnings("unused")
@ModuleData(name = "Watermark", category = Category.HUD, description = "modules.watermark.description")
public class Watermark extends Module {

    private final StringSetting design = new StringSetting.Builder()
            .name("modules.watermark.design")
            .value("Modern")
            .values("Modern", "Neverlose")
            .build();

    public Watermark() {
        design.addListener(((setting, oldValue, newValue) -> setFont()));
        toggle();
    }

    private final SimpleFontRenderer iconFont = Atani.instance.fontStorage.getFont("Icons-FilledRounded", 14).newRenderer();
    private SimpleFontRenderer font1 = Atani.instance.fontStorage.getFont("Google-Bold", 11).newRenderer();
    private SimpleFontRenderer font2 = Atani.instance.fontStorage.getFont("Google-Regular", 10).newRenderer();

    private void setFont() {
        switch (design.getValue()) {
            case "Modern" -> {
                font1 = Atani.instance.fontStorage.getFont("Google-Medium", 11).newRenderer();
                font2 = Atani.instance.fontStorage.getFont("Google-Regular", 10).newRenderer();
            }
            case "Neverlose" -> {
                font1 = Atani.instance.fontStorage.getFont("Inter-Bold", 12).newRenderer();
                font2 = Atani.instance.fontStorage.getFont("Inter-Bold", 14).newRenderer();
            }
        }
    }

    @Listen(priority = Priority.HIGHEST)
    private void onEvent(OffsetRender2DEvent event) {
        String text;
        switch (design.getValue()) {
            case "Modern" -> {
                text = "§nAtani";
                float textWidth = font1.getStringWidth(text);
                Renderer.drawRoundedSelectiveRectangle(5, 5, 120, 22, 4, Mocha.BASE.getRGB(), true, true, false, false);

                iconFont.drawYCenteredString(Icon.HOME.letter, 9, 5 + 22 / 2f, -1);
                font1.drawYCenteredString(text, 120 - font1.getStringWidth(text), 5 + 22 / 2f, -1);

                float yOffset = 5 + 22 - 1;
                String[] objects = new String[] {"FPS", "BPS"};
                for (String str : objects) {
                    boolean last = str.equals(objects[objects.length - 1]);

                    Renderer.drawRoundedSelectiveRectangle(5, yOffset, 120, 22, 4, Mocha.MANTLE.getRGB(), false, false, last, last);
                    switch (str) {
                        case "FPS" -> font2.drawYCenteredString("FPS: " + fps(), 9 + 2, yOffset + 22 / 2f, Mocha.OVERLAY_0);
                        case "BPS" -> font2.drawYCenteredString("BPS: " + MathUtil.round(MovementUtil.getSpeed() * 20, 2), 9 + 2, yOffset + 22 / 2f, Mocha.OVERLAY_0);
                    }

                    yOffset += 22 - 1;
                }

                event.setOffset(event.getOffset() + yOffset);
            }
            case "Neverlose" -> {
                text = String.format("§8|§f %s fps §8|§f %s §8|§f %s", fps(), mc.getSession().getUsername(), mc.isSingleplayer() || mc.getCurrentServerData() == null ? "singleplayer" : mc.getCurrentServerData().serverIP);
                float nameWidth = font2.getStringWidth("Atani".toUpperCase());
                float textWidth = font1.getStringWidth(text);
                float totalWidth = nameWidth + textWidth + 10;

                float x = 3;
                float y = 5;
                float height = font1.getFontHeight() + 5;

                Renderer.drawRectangle(x, y, totalWidth, height, new Color(0, 0, 0, 160).getRGB());

                float nameX = x + 4;
                float textX = nameX + nameWidth + 2;
                float textY = y + (height - font1.getFontHeight()) / 2;

                font2.drawString("Atani".toUpperCase(), nameX + 1.4F, textY - 1.4F, new Color(33, 78, 169).getRGB());
                font2.drawString("Atani".toUpperCase(), nameX, textY - 1f, new Color(255, 255, 255).getRGB());
                font1.drawString(text, textX, textY, new Color(255, 255, 255).getRGB());

                event.setOffset(event.getOffset() + textY + height);
            }
        }
    }
}