package tech.atani.client.module.impl.hud;

import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.util.vector.Vector2f;
import tech.atani.client.Atani;
import tech.atani.client.event.impl.Render2DEvent;
import tech.atani.client.module.Module;
import tech.atani.client.module.data.Category;
import tech.atani.client.module.data.ModuleData;
import tech.atani.client.screen.Icon;
import tech.atani.client.screen.customPanels.Panel;
import tech.atani.client.screen.customPanels.elements.impl.LabelLeft;
import tech.atani.client.screen.vec.SizeVector;
import tech.atani.client.setting.impl.SliderSetting;
import tech.atani.client.setting.impl.StringSetting;
import tech.atani.client.util.client.events.base.Listen;
import tech.atani.client.util.game.entity.EntityUtil;
import tech.atani.client.util.game.render.ColorUtil;
import tech.atani.client.util.game.render.font.gui.font.renderer.SimpleFontRenderer;
import tech.atani.client.util.game.render.shader.data.renderer.Renderer;
import tech.atani.client.util.system.math.MathUtil;

import java.awt.*;

@ModuleData(name = "TargetDisplay", category = Category.HUD, description = "modules.targetdisplay.description")
@SuppressWarnings("unused")
public class TargetDisplay extends Module {

    private final StringSetting design = new StringSetting.Builder()
            .name("modules.targetdisplay.design")
            .value("Modern")
            .values("Modern", "Blocky")
            .build();

    private final SimpleFontRenderer font1 = Atani.instance.fontStorage.getFont("Google-Bold", 11).newRenderer();

    private final SliderSetting xPosition = new SliderSetting.Builder()
            .name("modules.targetdisplay.xpos")
            .value(500)
            .min(0)
            .max(2000)
            .build();

    private final SliderSetting yPosition = new SliderSetting.Builder()
            .name("modules.targetdisplay.ypos")
            .value(300)
            .min(0)
            .max(2000)
            .build();

    @Listen
    private void onRender(Render2DEvent event) {
        if (EntityUtil.getTarget() instanceof EntityPlayer) {
            switch (design.getValue()) {
                case "Modern" -> {
                    SizeVector size = new SizeVector(120, 22, 0, 3);
                    if (EntityUtil.getTarget().getName().length() > 10) {
                        size.width += 15;
                    }
                    Panel targetPanel = new Panel(new Vector2f(xPosition.floatValue(), yPosition.floatValue()), size, EntityUtil.getTarget().getName(), Icon.GRID);
                    LabelLeft targetHealth = new LabelLeft(targetPanel, "Health: " + (int) EntityUtil.getTarget().getHealth());

                    targetPanel.draw(targetHealth);
                }
                case "Blocky" -> drawTargetHUD((EntityPlayer) EntityUtil.getTarget(), xPosition.floatValue(), yPosition.floatValue());
            }
        }
    }

    private float previousHealth = 0;

    private void drawTargetHUD(EntityPlayer player, float x, float y) {
        SizeVector size = new SizeVector(120, 40);
        if (EntityUtil.getTarget().getName().length() > 13) {
            size.width += 16;
        }

        Renderer.drawRectangle(x, y, size.width, size.height, new Color(0, 0, 0, 150));

        int headSize = 36;
        float headX = x + 2;
        float headY = y + 2;
        Renderer.drawHead(EntityUtil.getTarget(), headX, headY, headSize, Color.WHITE);

        int healthBarWidth = (int) (size.width - 42);
        int healthBarHeight = 6;
        float healthBarX = x + headSize + 4;
        float healthBarY = y + size.height - healthBarHeight - 2f;
        Renderer.drawRectangle(healthBarX, healthBarY, healthBarWidth, healthBarHeight, new Color(50, 50, 50, 150));

        float currentHealth = player.getHealth();
        float maxHealth = player.getMaxHealth();
        float healthPercentage = currentHealth / maxHealth;

        previousHealth = MathUtil.lerp(previousHealth, currentHealth, 0.1f);
        previousHealth = Math.max(0, Math.min(previousHealth, maxHealth));

        float animatedHealth = MathUtil.lerp(0, healthBarWidth, previousHealth / maxHealth);

        int[] healthColors = {0xFF00FF00, 0xFFFF0000};
        int blendedColor = ColorUtil.blendColours(healthColors, healthPercentage);
        Color healthColor = new Color(blendedColor, true);

        Renderer.drawRectangle(healthBarX, healthBarY, (int) animatedHealth, healthBarHeight, healthColor);

        String playerName = player.getName();

        float textX = x + headSize + 4;
        float textY = y + size.height - font1.getFontHeight() - 8;
        font1.drawString(playerName, textX, textY, Color.WHITE);
    }
}