package tech.atani.client.module.impl.hud;

import org.lwjgl.input.Keyboard;
import tech.atani.client.Atani;
import tech.atani.client.event.impl.OffsetRender2DEvent;
import tech.atani.client.module.Module;
import tech.atani.client.module.data.Category;
import tech.atani.client.module.data.ModuleData;
import tech.atani.client.util.client.events.base.Listen;
import tech.atani.client.util.client.events.base.Priority;
import tech.atani.client.util.game.render.animation.Animation;
import tech.atani.client.util.game.render.catppuccin.Mocha;
import tech.atani.client.util.game.render.font.gui.font.renderer.SimpleFontRenderer;
import tech.atani.client.util.game.render.shader.data.renderer.Renderer;

import java.awt.*;
import java.util.ArrayList;
import java.util.List;

@SuppressWarnings("unused")
@ModuleData(name = "Keystrokes", description = "modules.keystrokes.description", category = Category.HUD)
public class Keystrokes extends Module {

    private final SimpleFontRenderer icon = Atani.instance.fontStorage.getFont("Icons-FilledRounded", 14).newRenderer();
    private final SimpleFontRenderer font1 = Atani.instance.fontStorage.getFont("Google-Medium", 11).newRenderer();
    private final SimpleFontRenderer font2 = Atani.instance.fontStorage.getFont("Google-Regular", 10).newRenderer();

    private final List<KeyVector> keys = new ArrayList<>();

    @Override
    public void onEnable() {
        super.onEnable();

        keys.clear();
        keys.add(new KeyVector(mc.gameSettings.keyBindForward.getKeyCode(), new Animation(255, 2.f)));
        keys.add(new KeyVector(mc.gameSettings.keyBindLeft.getKeyCode(), new Animation(255, 2.f)));
        keys.add(new KeyVector(mc.gameSettings.keyBindBack.getKeyCode(), new Animation(255, 2.f)));
        keys.add(new KeyVector(mc.gameSettings.keyBindRight.getKeyCode(), new Animation(255, 2.f)));
        keys.add(new KeyVector(mc.gameSettings.keyBindJump.getKeyCode(), new Animation(255, 2.f)));
    }

    @Listen(priority = Priority.LOWEST)
    private void onEvent(OffsetRender2DEvent event) {
        float y = event.getOffset() + 10;

        float boxWidth = 120;
        float baseSize = 22;
        float spacing = 4;

        float firstKeyX = (boxWidth / 2f) - (baseSize / 2f);

        float secondRowWidth = (3 * baseSize) + (2 * spacing);
        float rowStartX = (boxWidth / 2f) - (secondRowWidth / 2f);

        float x = firstKeyX;
        int count = 0;

        for (KeyVector key : keys) {
            float keySizeWidth = baseSize;

            boolean down = Keyboard.isKeyDown(key.keyCode);
            if (down) {
                key.animation.update(0);
            } else {
                key.animation.update(255);
            }

            int alpha = (int) key.animation.getValue();
            alpha = Math.max(0, Math.min(255, alpha));

            Color animatedColor = new Color(Mocha.BASE.getRed(), Mocha.BASE.getGreen(), Mocha.BASE.getBlue(), alpha);

            if (count == 0) {
                y = event.getOffset() + 10;
                if (!Atani.instance.moduleStorage.getModule("Watermark").isEnabled() && Atani.instance.moduleStorage.getModule("Keybinds").isEnabled()) {
                    y = event.getOffset() + 80;
                }
            } else if (count < 4) {
                x = rowStartX + ((count - 1) * (baseSize + spacing));
                y = event.getOffset() + 10 + baseSize + spacing;
                if (!Atani.instance.moduleStorage.getModule("Watermark").isEnabled() && Atani.instance.moduleStorage.getModule("Keybinds").isEnabled()) {
                    y = event.getOffset() + 80 + baseSize + spacing;
                }
            } else {
                x = rowStartX;
                keySizeWidth = (baseSize * 3) + (2 * spacing);
                y += baseSize + spacing;
            }

            Renderer.drawRoundedSelectiveRectangle(x, y, keySizeWidth, baseSize, 4, Mocha.MANTLE.getRGB(), true, true, true, true);
            Renderer.drawRoundedSelectiveRectangle(x, y, keySizeWidth, baseSize, 4, animatedColor.getRGB(), true, true, true, true);
            font1.drawXYCenteredString(key.keyName(), x + keySizeWidth / 2f, y + baseSize / 2f, -1);

            count += 1;
        }

        event.setOffset(event.getOffset() + y);
    }

    private boolean isKeyJump(String key) {
        String jumpTranslated = Keyboard.getKeyName(mc.gameSettings.keyBindJump.getKeyCode());
        return key.equals(jumpTranslated);
    }

    public static class KeyVector {
        public int keyCode;
        public Animation animation;

        public KeyVector(int keyCode, Animation animation) {
            this.keyCode = keyCode;
            this.animation = animation;
        }

        public String keyName() {
            return Keyboard.getKeyName(keyCode);
        }
    }
}
